/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.rewire;

import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.layout.PositionableNode;
import org.nongnu.multigraph.rewire.AbstractRewire;
import org.nongnu.multigraph.rewire.EdgeLabeler;

public class CartesianRewire<N extends PositionableNode, L>
extends AbstractRewire<N, L> {
    private float range;

    public CartesianRewire(Graph<N, L> graph, EdgeLabeler<N, L> edgeLabeler, float f) {
        super(graph, edgeLabeler);
        this.range = f;
    }

    @Override
    public void rewire() {
        if (this.graph.size() < 2) {
            return;
        }
        if (this.graph.size() < 2) {
            return;
        }
        Object[] objectArray = this.graph.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = i + 1; j < objectArray.length; ++j) {
                Object l;
                PositionableNode positionableNode = (PositionableNode)objectArray[i];
                PositionableNode positionableNode2 = (PositionableNode)objectArray[j];
                double d = positionableNode.getPosition().distance(positionableNode2.getPosition());
                debug.printf("Cartesian: %s -> %s = %f\n", positionableNode, positionableNode2, d);
                if (d <= (double)this.range && (l = this.el.getLabel(positionableNode, positionableNode2)) != null) {
                    if (this.graph.successors(positionableNode).contains(positionableNode2)) continue;
                    this.graph.set(positionableNode, positionableNode2, l);
                    continue;
                }
                this.graph.remove(positionableNode, positionableNode2);
            }
        }
    }
}

