/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.rewire;

import java.util.Random;
import org.nongnu.multigraph.EdgeLabeler;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.rewire.Rewire;

public class RandomRewire<N, E>
extends Rewire<N, E> {
    Random r = new Random();
    int mindegree = 1;

    public RandomRewire(Graph<N, E> graph, EdgeLabeler<N, E> el) {
        super(graph, el);
    }

    public RandomRewire(Graph<N, E> graph, EdgeLabeler<N, E> el, int mindegree) {
        super(graph, el);
        this.mindegree = mindegree;
    }

    private void rewire_one(N node, int mindegree, N[] nodes) {
        while (this.graph.nodal_outdegree(node) < mindegree) {
            N to;
            while ((to = nodes[this.r.nextInt(nodes.length)]) == node) {
            }
            try {
                Object label = this.el.getLabel(node, to);
                if (label == null) continue;
                this.graph.set(node, to, label);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public RandomRewire<N, E> set_mindegree(int mindegree) {
        this.mindegree = mindegree;
        return this;
    }

    @Override
    public void rewire() {
        if (this.mindegree > this.graph.size() - 1) {
            throw new IllegalArgumentException("mindegree too high for size of graph");
        }
        Object[] nodes = this.graph.toArray(new Object[0]);
        this.graph.clear_all_edges();
        for (Object node : nodes) {
            this.rewire_one(node, this.mindegree, nodes);
        }
    }
}

