/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.perturb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.perturb.perturber;

public class RemoveAddEach<N, E>
implements perturber<N, E> {
    private Graph<N, E> network;
    private int remove_edges = 1;
    private int maxperturbs = 0;
    private long runs = 0L;
    private Iterator<Edge<N, E>> run_perturb_edges_iterator = null;
    private List<Edge<N, E>> run_perturb_edges = null;
    private List<Edge<N, E>> last_removed_edges = new ArrayList<Edge<N, E>>();

    public List<Edge<N, E>> last_removed_edges() {
        return Collections.unmodifiableList(this.last_removed_edges);
    }

    private void setup() {
        this.run_perturb_edges = new LinkedList<Edge<N, E>>();
        for (Object h : this.network) {
            for (Edge<N, E> edge : this.network.edges(h)) {
                this.run_perturb_edges.add(edge);
            }
        }
        this.run_perturb_edges_iterator = this.run_perturb_edges.iterator();
    }

    public RemoveAddEach(Graph<N, E> graph) {
        this.network = graph;
        this.setup();
    }

    public RemoveAddEach(Graph<N, E> graph, float remove_edges, int max_perturbs) {
        this.network = graph;
        this.remove_edges = (int)(remove_edges < 1.0f ? Math.max((float)this.network.size() * remove_edges, 1.0f) : remove_edges);
        this.maxperturbs = max_perturbs;
        this.setup();
    }

    @Override
    public List<Edge<N, E>> perturb() {
        ArrayList<Edge<N, E>> removed = new ArrayList<Edge<N, E>>();
        if (this.last_removed_edges.size() > 0) {
            this.restore();
            ++this.runs;
        } else if (this.maxperturbs <= 0 || this.runs <= (long)this.maxperturbs) {
            this.perturb_remove_ordered(removed, this.remove_edges);
        }
        return Collections.unmodifiableList(removed);
    }

    private List<Edge<N, E>> perturb_remove_ordered(List<Edge<N, E>> removed, int nremove) {
        while (removed.size() < nremove && this.run_perturb_edges_iterator.hasNext()) {
            Edge<N, E> edge = this.run_perturb_edges_iterator.next();
            debug.println("Remove edge " + edge);
            removed.add(edge);
            this.run_perturb_edges_iterator.remove();
            this.network.remove(edge.from(), edge.to());
        }
        this.last_removed_edges.addAll(removed);
        return removed;
    }

    @Override
    public int restore() {
        int size = this.last_removed_edges.size();
        for (Edge<N, E> e : this.last_removed_edges) {
            this.network.set(e.from(), e.to(), e.label());
        }
        this.last_removed_edges.clear();
        return size;
    }

    @Override
    public List<Edge<N, E>> removed_edges() {
        return Collections.unmodifiableList(this.last_removed_edges);
    }

    @Override
    public int clear_removed_edges() {
        int size = this.last_removed_edges.size();
        this.last_removed_edges.clear();
        return size;
    }
}

