/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.metrics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.metrics.dmap;

public class TraversalMetrics {
    public static <N, E> void traverse_graph(Graph<N, E> graph, graph_traversor<N, E> gt) {
        for (Object node : graph) {
            gt.node(node);
        }
    }

    public static <N, E> void traverse_graph(Graph<N, E> graph, graph_traversor<N, E>[] gts) {
        for (Object node : graph) {
            for (graph_traversor graph_traversor2 : gts) {
                graph_traversor2.node(node);
            }
        }
    }

    public static <N, E> int[] degree_distribution(Graph<N, E> graph) {
        int[] vals = new int[graph.max_nodal_degree() + 1];
        for (Object node : graph) {
            int n = graph.nodal_outdegree(node);
            vals[n] = vals[n] + 1;
        }
        return vals;
    }

    public static <N, E> float[] norm_degree_distribution(Graph<N, E> graph) {
        int[] degrees = TraversalMetrics.degree_distribution(graph);
        float[] vals = new float[degrees.length];
        for (int i = 0; i < degrees.length; ++i) {
            vals[i] = (float)degrees[i] / (float)graph.size();
        }
        return vals;
    }

    public static <N, E> int count(Graph<N, E> graph, node_test<N> t) {
        int count = 0;
        for (Object node : graph) {
            if (!t.test(node)) continue;
            ++count;
        }
        return count;
    }

    public static <N, E> int edges(Graph<N, E> graph) {
        int count = 0;
        for (Object node : graph) {
            count += graph.edge_outdegree(node);
        }
        return count / (graph.is_directed() ? 1 : 2);
    }

    private static <N, E> int FWdist(Graph<N, E> graph, dmap<N> dmap2, N from, N to) {
        if (from == to) {
            return 0;
        }
        int w = dmap2.dist(from, to);
        if (w < Integer.MAX_VALUE) {
            return w;
        }
        Collection<Edge<N, E>> edges = graph.edges(from, to);
        if (edges.size() > 0) {
            int min = Integer.MAX_VALUE;
            for (Edge<N, E> e : edges) {
                min = Math.min(min, e.weight());
            }
            return min;
        }
        return Integer.MAX_VALUE;
    }

    private static int FWdplus(int w1, int w2) {
        int max = Integer.MAX_VALUE;
        if (w1 == max || w2 == max) {
            return max;
        }
        if (w2 >= max - w1) {
            return max;
        }
        return w1 + w2;
    }

    public static <N, E> dmap<N> FloydWarshal(Graph<N, E> graph) {
        dmap dmap2 = new dmap();
        for (Object k : graph) {
            for (Object i : graph) {
                for (Object j : graph) {
                    dmap2.set(i, j, Math.min(TraversalMetrics.FWdist(graph, dmap2, i, j), TraversalMetrics.FWdplus(TraversalMetrics.FWdist(graph, dmap2, i, k), TraversalMetrics.FWdist(graph, dmap2, k, j))));
                }
            }
        }
        return dmap2;
    }

    public static <N, E> Map<String, Double> stats(Graph<N, E> graph) {
        return TraversalMetrics.stats(TraversalMetrics.FloydWarshal(graph), graph);
    }

    public static <N, E> Map<String, Double> stats(dmap<N> dmap2, Graph<N, E> graph) {
        HashMap<String, Double> results = new HashMap<String, Double>();
        double avg = 0.0;
        double delta2 = 0.0;
        int max = 0;
        int num = 0;
        int radius = Integer.MAX_VALUE;
        int diameter = 0;
        for (Map.Entry<N, Map<N, Integer>> from : dmap2.entrySet()) {
            int eccentricity = 0;
            for (Map.Entry<N, Integer> to : from.getValue().entrySet()) {
                int w = to.getValue();
                double delta = (double)w - avg;
                max = Math.max(max, w);
                debug.printf("%s -> %s: %d\n", from.getKey(), to.getKey(), w);
                if (w == 0) continue;
                eccentricity = Math.max(eccentricity, w);
                debug.printf("w: %d, num %d, avg %4f, delta2 %4f\n", w, num, avg, delta2 += delta * ((double)w - (avg += delta / (double)(++num))));
            }
            radius = Math.min(radius, eccentricity);
            diameter = Math.max(diameter, eccentricity);
        }
        double stddev = Math.sqrt(avg / Math.sqrt(num));
        results.put("max", Double.valueOf(max));
        results.put("avg", avg);
        results.put("stddev", stddev);
        results.put("stderr", stddev / Math.sqrt(num));
        results.put("radius", Double.valueOf(radius));
        results.put("diameter", Double.valueOf(diameter));
        return results;
    }

    public static interface node_test<N> {
        public boolean test(N var1);
    }

    public class traversor_degree_distribution<N, E>
    implements graph_traversor<N, E> {
        @Override
        public void node(N node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static interface graph_traversor<N, E> {
        public void node(N var1);
    }
}

