/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;

public class ShortestPathFirst<N, E> {
    private HashMap<N, SPFnode<N, E>> spfnodes = new HashMap();
    private PriorityQueue<SPFnode<N, E>> q = new PriorityQueue();
    private final Graph<N, E> g;
    private N root;

    public ShortestPathFirst(Graph<N, E> g) {
        this.g = g;
        if (g == null) {
            throw new IllegalArgumentException("graph must not be null");
        }
    }

    private void explore(SPFnode<N, E> v) {
        debug.printf("SPF: exploring %s\n", v);
        Set<Edge<N, E>> edges = this.g.edges(v.n);
        if (edges == null) {
            return;
        }
        for (Edge<N, E> edge : edges) {
            debug.printf("SPF: relaxing %s\n", edge);
            SPFnode<N, E> w = this.spfnodes.get(edge.to());
            if (w == null) {
                w = new SPFnode<N, E>(edge.to(), edge, edge.weight() + v.cost);
                this.spfnodes.put(w.n, w);
                this.q.add(w);
                continue;
            }
            if (edge.weight() + v.cost < w.cost) {
                w.cost = edge.weight() + v.cost;
                w.parents.clear();
                w.parents.add(edge);
                debug.printf("SPF: lower cost path found %s\n", w);
                continue;
            }
            if (edge.weight() + v.cost != w.cost) continue;
            w.parents.add(edge);
            debug.printf("SPF: equal cost path found %s\n", w);
        }
        if (debug.applies()) {
            debug.println("SPFnodes:");
            for (SPFnode sPFnode : this.spfnodes.values()) {
                debug.println("\t" + sPFnode);
            }
        }
    }

    public void run(N root) {
        if (root == null) {
            throw new IllegalArgumentException("root argument must not be null");
        }
        this.root = root;
        this.spfnodes.clear();
        this.q.clear();
        debug.println("SPF: initialising");
        SPFnode<N, Object> v = new SPFnode(root, null, 0);
        this.spfnodes.put(root, v);
        this.explore(v);
        debug.println("SPF: Search the nodes");
        while ((v = this.q.poll()) != null) {
            this.explore(v);
        }
        debug.println("SPF: done");
    }

    public List<Edge<N, E>> path(N to) {
        SPFnode<N, E> s;
        LinkedList l = null;
        while ((s = this.spfnodes.get(to)) != null && s.parents.size() > 0) {
            if (l == null) {
                l = new LinkedList();
            }
            debug.println("in path");
            Edge e = s.parents.getFirst();
            l.addFirst(e);
            to = e.from();
        }
        if (l != null) {
            Collections.reverse(l);
        }
        return l;
    }

    public Set<Edge<N, E>> edges(N to) {
        Object n;
        HashSet<Edge> edges = null;
        LinkedList explore = new LinkedList();
        explore.add(to);
        while ((n = explore.poll()) != null) {
            SPFnode<N, E> s = this.spfnodes.get(n);
            if (s == null || s.parents.size() == 0) continue;
            if (edges == null) {
                edges = new HashSet<Edge>();
            }
            for (Edge edge : s.parents) {
                explore.add(edge.from());
                edges.add(edge);
            }
        }
        return edges;
    }

    public Set<Edge<N, E>> edges() {
        HashSet edges = null;
        for (SPFnode<N, E> s : this.spfnodes.values()) {
            if (edges == null) {
                edges = new HashSet();
            }
            edges.addAll(s.parents);
        }
        return edges;
    }

    public N nexthop(N to) {
        SPFnode<N, E> s;
        N prev = null;
        while ((s = this.spfnodes.get(to)) != null && s.parents.size() > 0) {
            prev = to;
            to = s.parents.getFirst().from();
        }
        return prev;
    }

    public N root() {
        return this.root;
    }

    private class SPFnode<N, L>
    implements Comparable<SPFnode<N, L>> {
        final N n;
        LinkedList<Edge<N, L>> parents;
        int cost = 0;

        SPFnode(N n, Edge<N, L> path, int cost) {
            this.n = n;
            this.parents = new LinkedList();
            if (path != null) {
                this.parents.add(path);
            }
            this.cost = cost;
            debug.printf("SPFnode: created %s\n", this);
        }

        @Override
        public int compareTo(SPFnode<N, L> v) {
            return this.cost - v.cost;
        }

        public String toString() {
            return "N: " + this.n + ", " + this.cost + ", Edge to parent: " + (!this.parents.isEmpty() ? this.parents.get(0) : "<none>");
        }
    }
}

