/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.layout;

import java.awt.Dimension;
import java.util.Random;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.layout.Layout;
import org.nongnu.multigraph.layout.PositionableNode;
import org.nongnu.multigraph.layout.Vector2D;

public class ForceLayout<N extends PositionableNode, L>
extends Layout<N, L> {
    private double k;
    private double mintemp = 0.04;
    private double temperature = 0.08;

    public ForceLayout(Graph<N, L> graph, Dimension dimension, int n) {
        super(graph, dimension, n);
        this.k = 0.7 * Math.sqrt(dimension.getWidth() * dimension.getHeight() / (double)graph.size());
        debug.println("k: " + this.k);
    }

    private double attraction(double d) {
        return d * d / this.k;
    }

    private double repulsion(double d) {
        return this.k * this.k / d;
    }

    private double decay(double d) {
        return d * 0.7;
    }

    @Override
    public boolean layout(float f) {
        double d = 0.0;
        debug.println("force-layout start");
        for (PositionableNode positionableNode : this.graph) {
            double d2;
            Vector2D vector2D;
            Vector2D vector2D2 = positionableNode.getVelocity();
            vector2D2.setLocation(0.0, 0.0);
            debug.println("node: " + positionableNode + ", pos: " + positionableNode.getPosition());
            for (PositionableNode positionableNode2 : this.graph) {
                if (positionableNode2 == positionableNode) continue;
                if (positionableNode2.getPosition().x == positionableNode.getPosition().x && positionableNode2.getPosition().y == positionableNode.getPosition().y) {
                    vector2D = new Vector2D(0.01, 0.0);
                    Random random = new Random();
                    vector2D.rotate(random.nextInt(360));
                    positionableNode2.getPosition().plus(vector2D);
                }
                debug.println("\trepulsion with " + positionableNode2 + ", " + positionableNode2.getPosition());
                vector2D = new Vector2D(positionableNode.getPosition());
                vector2D.minus(positionableNode2.getPosition());
                debug.println("\t\tdelta1: " + vector2D);
                d2 = this.repulsion(vector2D.length());
                if (Double.isInfinite(d2)) {
                    debug.println("\t\trepf: " + d2);
                }
                vector2D.normalise();
                vector2D.times(d2);
                debug.println("\t\tdelta2: " + vector2D);
                vector2D2.plus(vector2D);
                debug.println("\tdisp after repf: " + vector2D2);
            }
            for (Edge edge : this.graph.edges(positionableNode)) {
                if (edge.to() == edge.from()) continue;
                debug.println("\tattraction with " + edge.to());
                vector2D = new Vector2D(positionableNode.getPosition());
                vector2D.minus(((PositionableNode)edge.to()).getPosition());
                debug.println("\t\tdelta1: " + vector2D + ", len " + vector2D.length());
                d2 = this.attraction(vector2D.length());
                debug.println("\t\tattrf: " + d2);
                vector2D.normalise();
                vector2D.times(d2);
                debug.println("\t\tdelta2: " + vector2D);
                vector2D2.minus(vector2D);
                debug.println("\tdisp: " + vector2D2);
            }
            debug.println("\tresultant v: " + vector2D2);
            Vector2D vector2D3 = positionableNode.getPosition();
            Vector2D object2 = positionableNode.getVelocity();
            debug.println("node pos: " + vector2D3);
            debug.println("\tv: " + object2);
            this.temperature = Math.max(this.decay(this.temperature), this.mintemp);
            object2.times((double)f * this.temperature);
            debug.println("\tv2: " + object2);
            vector2D3.plus(object2);
            debug.println("\tp2: " + vector2D3);
            vector2D3.x = Math.min(Math.max((double)(-this.bound.width / 2), vector2D3.x), (double)(this.bound.width / 2));
            vector2D3.y = Math.min(Math.max((double)(-this.bound.height / 2), vector2D3.y), (double)(this.bound.height / 2));
            double d3 = object2.magnitude();
            d += (double)positionableNode.getMass() * d3 * d3;
            debug.println("\tresult: " + vector2D3);
        }
        debug.println("kve: " + d);
        return d > 1.0;
    }
}

