/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.Node;

public class MultiGraph<N, L>
implements Graph<N, L> {
    HashMap<N, Node<N, L>> nodes = new HashMap();
    HashMap<L, Edge<N, L>> edges;
    private Set<N> nodeset = this.nodes.keySet();
    private Set<L> edgeset;

    public MultiGraph() {
        this.edges = new HashMap();
        this.edgeset = this.edges.keySet();
    }

    final Node<N, L> get_node(N n) {
        Node<N, L> node = this.nodes.get(n);
        if (node == null) {
            node = new Node(n);
            this.nodes.put(n, node);
        }
        return node;
    }

    final void _set(Node<N, L> node, Node<N, L> node2, int n, L l) {
        assert (node != null);
        assert (node2 != null);
        assert (l != null);
        node.set(node2, n == 0 ? n : 1, l);
    }

    protected void _set(N n, N n2, int n3, L l) {
        Node<N, L> node = null;
        assert (n != null);
        Node<N, L> node2 = this.get_node(n);
        node = n2 == null || n2 == n ? node2 : this.get_node(n2);
        this._set((N)node2, (N)node, n3, l);
    }

    @Override
    public synchronized void set(N n, N n2, L l) {
        this._set(n, n2, 1, l);
    }

    @Override
    public synchronized void set(N n, N n2, L l, int n3) {
        this._set(n, n2, n3, l);
    }

    protected boolean _remove(N n, N n2, L l) {
        Node<N, L> node = null;
        if (n == null) {
            throw new NullPointerException("remove: 'from' must not be null");
        }
        if (n2 == null) {
            throw new NullPointerException("remove: 'from' must not be null");
        }
        Node<N, L> node2 = this.nodes.get(n);
        if (node2 == null) {
            return false;
        }
        Node<N, L> node3 = node = n2 == n ? node2 : this.nodes.get(n2);
        if (node == null) {
            return false;
        }
        if (l != null) {
            return node2.remove(node, l);
        }
        return node2.remove(node);
    }

    @Override
    public synchronized boolean remove(N n, N n2, L l) {
        return this._remove(n, n2, l);
    }

    @Override
    public synchronized boolean remove(N n, N n2) {
        return this._remove(n, n2, null);
    }

    @Override
    public synchronized Set<Edge<N, L>> edges(N n) {
        Node<N, L> node = this.nodes.get(n);
        return node.edges();
    }

    @Override
    public synchronized Set<N> successors(N n) {
        HashSet<N> hashSet = new HashSet<N>();
        assert (n != null);
        Node<N, L> node = this.nodes.get(n);
        for (Edge<N, L> edge : node.edges()) {
            hashSet.add(edge.to());
        }
        return hashSet;
    }

    @Override
    public synchronized int edge_outdegree(N n) {
        return this.get_node(n).edge_outdegree;
    }

    @Override
    public synchronized int nodal_outdegree(N n) {
        return this.get_node(n).nodal_outdegree();
    }

    @Override
    public synchronized float avg_nodal_degree() {
        float f = 0.0f;
        int n = 0;
        for (Node<N, L> node : this.nodes.values()) {
            f += ((float)node.nodal_outdegree() - f) / (float)(++n);
        }
        return f;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node<N, L> node : this.nodes.values()) {
            stringBuilder.append(node + "\n");
            for (Edge<N, L> edge : node.edges()) {
                stringBuilder.append("\t" + edge + "\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean add(N n) {
        return this.get_node(n) != null;
    }

    @Override
    public boolean addAll(Collection<? extends N> collection) {
        return this.nodeset.addAll(collection);
    }

    @Override
    public void clear() {
        this.nodes.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.nodeset.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.nodeset.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.nodeset).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.nodeset).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.nodeset.isEmpty();
    }

    @Override
    public int size() {
        return this.nodeset.size();
    }

    @Override
    public Object[] toArray() {
        return this.nodeset.toArray();
    }

    @Override
    public <N> N[] toArray(N[] NArray) {
        return this.nodeset.toArray(NArray);
    }

    @Override
    public Iterator<N> iterator() {
        return this.nodeset.iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.nodeset.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.nodeset.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.nodeset.retainAll(collection);
    }
}

