# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'test/unit'
require 'pathname'
require 'msgcab/entity'

include MsgCab

class TestEntity < Test::Unit::TestCase
  def test_s_parse
    path = Pathname.new(__FILE__).dirname + 'test-entity0.txt'
    entity = Entity.parse(path.read)
    assert(entity.cid.empty?)
  end

  def test_cid
    path = Pathname.new(__FILE__).dirname + 'test-entity1.txt'
    entity = Entity.parse(path.read)
    assert(entity.multipart?)
    assert_equal(1, entity.size)
    e = entity.find('1.1.2.1')
    assert_equal([0, 1, 0], e.cid)
    assert_equal("b\n", e.decode)
  end

  def test_mbox
    path = Pathname.new(__FILE__).dirname + 'test-entity2.txt'
    entity = Entity.parse(path.read)
    assert_match(/\AFrom aaa@bbb/, entity.mbox)
    path = Pathname.new(__FILE__).dirname + 'test-entity0.txt'
    entity = Entity.parse(path.read)
    assert_match(/\AFrom bogus@example.org/, entity.mbox)
  end
end
