# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'test/unit'
require 'pathname'
require 'fileutils'
require 'msgcab/plugin'

include MsgCab

class TestPlugin < Test::Unit::TestCase
  @@loader = nil

  def setup
    unless @@loader
      Config.load(Pathname.new(__FILE__).dirname + 'test-plugin0.yml')
      @@loader = PluginLoader.new
    end
  end

  def test_start_plugins
    @@loader.attributes[:test_start_plugins] = true
    @@loader.start_plugins
    assert(@@loader.running?('plugin0'))
    assert_nil(@@loader.attributes[:test_start_plugins])
    assert(!@@loader.running?('plugin1'))
    assert(@@loader.running?('plugin2'))
  end

  def test_start_plugins_flavor
    begin
      MsgCab.const_set(:FLAVOR, 'webapp')
      @@loader.start_plugins
      assert(@@loader.running?('plugin1'))
    ensure
      MsgCab.module_eval {remove_const(:FLAVOR)}
    end
  end

  def test_stop_plugins
    @@loader.start_plugins
    @@loader.attributes[:test_stop_plugins] = true
    @@loader.stop_plugin('plugin0')
    assert_nil(@@loader.attributes[:test_stop_plugins])
  end
end
