# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'test/unit'
require 'msgcab/callback'

include MsgCab

class TestCallback < Test::Unit::TestCase
  def test_add_remove_callback
    obj = Object.new
    obj.extend(Callback)
    assert_nothing_raised do
      obj.remove_callback(:a, :f1) {}
    end
    assert_nothing_raised do
      obj.add_callback(:a, :f1) {}
    end
    assert_nothing_raised do
      obj.remove_callback(:a, :f1) {}
    end
  end

  def test_run_callback
    obj = Object.new
    obj.extend(Callback)
    a = false
    obj.add_callback(:a, :f1) {a = true}
    obj.run_callback(:a)
    assert_equal(true, a)
    a = false
    obj.remove_callback(:a, :f1)
    obj.run_callback(:a)
    assert_equal(false, a)
  end

  def test_run_callback_with_args
    obj = Object.new
    obj.extend(Callback)
    a = false
    obj.add_callback(:a, :f1) {|arg| a = arg}
    obj.run_callback(:a, true)
    assert_equal(true, a)
    obj.run_callback(:a)
    assert_nil(a)
  end
end
    
