# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

class MaskMailAddressPlugin < MsgCab::Plugin
  def start_plugin
    MsgCab::Callback.add_callback(:view_initialize, :add_mask_mail_address) do 
      |view|
      view.add_anchor(:body, MaskMailAddress, true)
      view.add_anchor(:field_body, MaskMailAddress, true)
    end
  end

  class MaskMailAddress < MsgCab::WebApp::Anchor
    def initialize(chain, view)
      super(chain, view)
    end

    FQDN = /[a-z0-9][-.a-z0-9]+\.(?:biz|com|edu|gov|int|mil|net|org|aero|coop|info|name|museum|arpa|pro|uucp|bitnet|bofh|[a-z][a-z])/

    MailAddressPat = /[-a-z0-9$%(*=?\[_][^<>\")!;:,{}\n\t ]*@#{FQDN}/i

    ReservedDomainNames = %w(test example invalid localhost
	example.com example.net example.org)

    SubstMailAddress = 'bogus@example.org'

    include HTree.compile_template(<<'End')
<span _template="replace_text(text)">
  <span _iter="text.split(/(#{MaskMailAddressPlugin::MaskMailAddress::MailAddressPat.disable_capture})/o).each//s">
    <span _if="MaskMailAddressPlugin::MaskMailAddress::MailAddressPat =~ s" _else=non_mailaddress>
      <span _call='next_anchor.replace_text(MaskMailAddressPlugin::MaskMailAddress::SubstMailAddress)'></span>
    </span>
    <span _template="non_mailaddress" _call="next_anchor.replace_text(s)"></span>
  </span>
</span>
End
  end
end
