# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

module MsgCab
  module Callback
    def self.extend_object(obj)
      super(obj)
      obj.__send__(:callback_initialize)
    end

    def add_callback(name, function_name, &block)
      raise ArgmentError, 'no block' unless block_given?
      chain = @callback_table[name] ||= []
      chain.push([function_name, block])
    end

    def remove_callback(name, function_name)
      chain = @callback_table[name]
      return unless chain
      chain.delete_if do |callback|
        callback[0] == function_name
      end
    end

    def run_callback(name, *args)
      chain = @callback_table[name]
      return unless chain
      chain.each do |function_name, block|
        block.call(*args)
      end
    end

    private
    def callback_initialize
      @callback_table = {}
    end

    self.extend(Callback)
  end
end
