# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'test/unit'
require 'msgcab/disjoint'

include MsgCab

class TestDisjoint < Test::Unit::TestCase
  def test_initialize
    assert(Disjoint.new.to_a.empty?)
  end

  def test_make_set
    disjoint = Disjoint.new
    assert_equal(0, disjoint.make_set(0))
    assert_equal(1, disjoint.to_a.size)
  end

  def test_link_sets
    disjoint = Disjoint.new
    disjoint.make_set(0)
    disjoint.make_set(1)
    disjoint.link_sets(0, 1)
    assert_equal([[0, 1, 1], [1, 2, 1]], disjoint.to_a)
  end

  def test_find_with_compression
    disjoint = Disjoint.new
    disjoint.make_set(0)
    disjoint.make_set(1)
    disjoint.make_set(2)
    disjoint.make_set(3)
    disjoint.link_sets(0, 1)
    disjoint.link_sets(1, 2)
    disjoint.link_sets(2, 3)
    assert_equal(1, disjoint.find_with_compression(0))
    assert_equal(1, disjoint.find_with_compression(1))
    assert_equal(3, disjoint.find_with_compression(2))
    assert_equal(3, disjoint.find_with_compression(3))
  end

  def test_union_sets
    disjoint = Disjoint.new
    disjoint.make_set(0)
    disjoint.make_set(1)
    disjoint.make_set(2)
    disjoint.make_set(3)
    disjoint.union_sets(0, 1)
    disjoint.union_sets(1, 2)
    disjoint.union_sets(2, 3)
    parents = disjoint.to_a.collect {|index, rank, parent| parent}
    parents.each do |parent|
      assert_equal(parents[0], parent)
    end
  end
end
