# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

module MsgCab
  class Disjoint
    def initialize
      @parent = Array.new
      @rank = Array.new
    end

    def make_set(x)
      unless @rank[x]
        @rank[x] = 1
        @parent[x] = x
      end
      x
    end

    def link_sets(x, y)
      if @rank[x] <= @rank[y]
        if @rank[x] == @rank[y]
          @rank[y] += 1
        end
        @parent[x] = y
        y
      else
        @parent[y] = x
        x
      end
    end

    def find_with_compression(x)
      ancestor = @parent[x]
      old_x, old_ancestor = x, ancestor
      while ancestor != x
        x = ancestor
        ancestor = @parent[ancestor]
      end
      x = old_ancestor
      while ancestor != x
        @parent[old_x] = ancestor
        old_x = x
        x = @parent[old_x]
      end
      ancestor
    end

    def union_sets(x, y)
      link_sets(find_with_compression(x), find_with_compression(y))
    end

    def to_a
      result = Array.new
      @rank.each_with_index do |rank, index|
        result << [index, rank, @parent[index]] if rank
      end
      result
    end
  end
end
