# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'test/unit'
require 'pathname'
require 'msgcab/mailtree'

include MsgCab

class TestMailTree < Test::Unit::TestCase
  def setup
    Config.load(Pathname.new(__FILE__).dirname + 'test-mailtree0.yml')
  end

  def test_number_to_path
    mailtree = MailTree.new
    path = Pathname.new(__FILE__).dirname + 'test-mailtree/3/01/00/00'
    assert_equal(path.expand_path, mailtree.number_to_path(10000))
  end

  def test_path_to_number
    mailtree = MailTree.new
    path = Pathname.new(__FILE__).dirname + 'test-mailtree/3/01/00/00'
    assert_equal(10000, mailtree.path_to_number(path))
  end
end
