# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'msgcab/database'
require 'msgcab/mailtree'
require 'msgcab/callback'
require 'msgcab/plugin'

module MsgCab
  module CLI
    def compress_numbers(numbers)
      ranges = Array.new
      last = first = numbers.shift
      numbers.each do |number|
        if number == last + 1
          last = number
        else
          if last == first
            ranges << first
          else
            ranges << "#{first}-#{last}"
          end
          last = first = number
        end
      end
      ranges << "#{first}-#{last}" if last != first
      ranges.join(',')
    end

    def uncompress_numbers(ranges)
      numbers = Array.new
      ranges.split(/\s*,\s*/).each do |range|
        if range =~ /(\d+)-(\d+)/
          numbers |= ($1.to_i .. $2.to_i).to_a
        else
          numbers |= [range.to_i]
        end
      end
      numbers
    end

    module_function :compress_numbers
    module_function :uncompress_numbers

    def database
      @@database ||= MsgCab::Database.instance
    end
      
    def mailtree
      @@mailtree ||= MsgCab::MailTree.new
    end

    module_function :database
    module_function :mailtree

    class Common
      def initialize(opts)
        @opts = opts
        self.extend(MsgCab::Callback)
	loader = MsgCab::PluginLoader.new
        loader.attributes[:cli] = self
	loader.start_plugins
      end
      attr_reader :opts
    end
  end
end
