# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'msgcab/entity'
require 'msgcab/encode'

class TitleRule
  def apply(number)
    entity = MsgCab::Entity.parse(MsgCab::CLI.mailtree.fetch(number))
    entity = entity[0] if entity.multipart?
    return unless entity.content_type == 'text/plain'
    decoded = entity.decode_body
    decoded.gsub!(/^[a-z-]+:.*/i, '')
    decoded.sub!(/^(?:in|on|at) .+ (?:wrote|writes|said):/mi, '')
    decoded.gsub!(/^\w*[|>].*/i, '')
    decoded.sub!(/\A\s*/mi, '')
    decoded.gsub!(/\s+/m, ' ')
    return decoded[/\A.{0,80}/mi]
  end
end
