# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'tempfile'

class EstraierPlugin < MsgCab::Plugin
  def start_plugin
    attributes[:cli].add_callback(:after_filter, :estraier) do |numbers|
      numbers.each do |number|
        est_path = MsgCab::Config['estraier', 'estraier_index_path'] || './est'
        Dir.mkdir est_path unless File.directory? est_path
        estindex_path = MsgCab::Config['estraier', 'estindex_path']
        if estindex_path
          estindex_path = MsgCab::Config.absolute_path(estindex_path)
        else
          estindex_path = 'estindex'
        end
        estindex_opts = MsgCab::Config['estraier', 'estindex_opts'] || Array.new

        tempfile = Tempfile.new('est')
        tempfile.write(cli.mailtree.number_to_path(number))
        tempfile.close
        filters = cli.database.filters_by_number(number)
        filters.each do |filter|
          pid = fork {
            exec(*[estindex_path, 'register',
                   estindex_opts.collect {|opt| opt.untaint},
                   '-msuf', '*',
                   '-list', tempfile.path,
                   "#{est_path}/#{filter[1]}"].flatten) 
          }
          Process.waitpid(pid)
        end
      end
    end
  end
end
