# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'msgcab/config'
require 'msgcab/webapp/view'

module MsgCab
  module WebApp
    class Error < StandardError; end
    class InvalidRequest < Error; end

    class Controller
      @@rules = Array.new

      def self.define_rule(name, pat, *capture_names)
        @@rules.unshift([name, pat, *capture_names])
      end

      def handle_request(webapp)
        begin
          path = (webapp.path_info || '').sub(%r|\A/+|, '').sub(%r|/+\z|, '')
          rule = @@rules.detect {|name, pat, *capture_names| path =~ pat}
          unless rule
            raise InvalidRequest, 'unknown request'
          end
          unless respond_to?("do_#{rule[0]}")
            raise InvalidRequest, "unknown request: #{rule[0]}"
          end
          send("do_#{rule[0]}", webapp, *$~.captures)
        rescue Exception => e
          raise e if Config['webapp', 'debug']
          e = Error.new('Internal error') unless e.kind_of? Error
          view = View.new(webapp)
          view.attributes[:cause] = e
          view.output_template('error.html')
        end
      end
    end
  end
end
