// Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology

// This file is part of msgcab.

// msgcab is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// msgcab is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with msgcab; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

threadPat = /open1\.png$/;

function replaceNodeImage(node, close) {
  var imgs = node.getElementsByTagName("img");
  var img = imgs[imgs.length - 1];
  if (close) {
    node.style.color = "#8B0300";
    img.src = img.src.replace(/open1\.png$/, "close.png");
  } else {
    node.style.color = "#000000";
    img.src = img.src.replace(/close\.png$/, "open1.png");
  }
}

function makeThreadToggleHandler(parent, thread) {
  return function (e) {
    var pat = new RegExp(thread + "\\b");
    var nodes = document.getElementsByTagName("tr");
    var node = nodes[parent];
    var imgs = node.getElementsByTagName("img");
    var img = imgs[imgs.length - 1];
    var close = threadPat.test(img.src);
    replaceNodeImage(node, close)
    for (var j = parent + 1; j < nodes.length; j++) {
      node = nodes[j];
      if (node.className == "")
	continue;
      if (node.className.search(pat) < 0)
	break;
      replaceNodeImage(node, close);
      node.style.display = close ? "none" : "";
    }
  }
}

var nodes = document.getElementsByTagName("tr");
for (var i = 0; i < nodes.length; i++) {
  var node = nodes[i];
  var imgs = node.getElementsByTagName("img");
  if (imgs.length < 1)
    continue;
  var img = imgs[imgs.length - 1];
  if (node.className && threadPat.test(img.src)) {
    threads = node.className.split(/\s+/);
    last = threads[threads.length - 1]
      if (!/^thread\d+$/.test(last))
      last = threads[threads.length - 2];
    img.onclick = makeThreadToggleHandler(i, last);
  }
}
