/* This file is part of the MPFRCPP Library.

   Copyright (c) 2006-2007 Alexey V. Beshenov <bav.272304@gmail.com>.

   The MPFRCPP Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of the
   License, or (at your option) any later version.

   The MPFRCPP Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the MPFRCPP Library; see the file COPYING.LIB. If
   not, write to the Free Software Foundation, Inc., 51 Franklin Street,
   Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file fp_comparator.cpp
 * @date 2007-04-09
 * Example of correct FP-numbers comparison.
 */

#include "../misc/copyleft.hpp" // internal::copyleft();
#include <iostream>
#include <mpfrcpp/mpfrcpp.hpp>
#include <mpfrcpp/extra/fp_comparator.hpp>

using namespace std;
using namespace mpfr;

#define MAX_ITER 10000

/**
 * In this example we are calculating
 *     sum_{i=0}^n (-1)^n x^{2i+1} / (2i+1)!
 * until x^{2i+1} / (2i+1)! is greater than machine epsilon.
 *
 * Note that it is a quick example of using mpfrcpp::FpComparator and you
 * MUST NOT use this technique to evaluate series.
 */

int main () {

    FpComparator fc;
    Real x (1), zero (0), sum (0);
    size_t i = 0;

    for (; i < MAX_ITER; i++) {
        Real m = Pow (x, 2*i+1) / Factorial(2*i+1);
        if ( fc(m, zero) == 0 ) break; // Should not get here
        if (i % 2) sum -= m;
        else sum += m;
    }

    cout << "Result is " << sum << ", " << i << " iteration(s) used" << endl;

    return 0;
}
