/* This file is part of the MPFRCPP Library.

  Copyright (c) 2006 -- 2007 Alexey V. Beshenov <bav.272304@gmail.com>.

  The MPFRCPP Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  The MPFRCPP Library is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the MPFRCPP Library; see the file COPYING.LIB. If
  not, write to the Free Software Foundation, Inc., 51 Franklin Street,
  Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file mpfrcpp.hpp
 * @date 2007-04-09
 * THIS HEADER SHOULD BE INCLUDED TO USE MPFRCPP.
 */

#ifndef MPFRCPP
#define MPFRCPP

//------------------------------------------------------------

/**
 * @name INCLUDED_BY_MPFRCPP
 * We define INCLUDED_BY_MPFRCPP macro and undefine it at the end of
 * this file to prevent including of internal headers by user.
 */

#define INCLUDED_BY_MPFRCPP

//------------------------------------------------------------

#include <mpfr.h>
#include <gmp.h>
#include <gmpxx.h>

//------------------------------------------------------------

#ifdef __GMP_PLUSPLUS__
#define GMP_CPP_INTERFACE
#endif

//------------------------------------------------------------

/* Don't use MPFRCPP_VERSION_ definitions unless you really need
   preprocessing. Use Version class from "core/version.hpp". */
#define MPFRCPP_VERSION_MAJOR 1
#define MPFRCPP_VERSION_MINOR 2
#define MPFRCPP_VERSION_PATCHLEVEL 0

//------------------------------------------------------------

// Namespaces
/// The MPFRCPP namespace
namespace mpfrcpp {
/// The MPFRCPP internal namespace, DO NOT ACCESS
    namespace internal {}
/// The MPFRCPP test classes namespace
    namespace test {}
}

/// The standard C++ library namespace. MPFRCPP overloads some
/// std functions for mpfrcpp::Real type.
namespace std {}

//------------------------------------------------------------

// Library Classes
#include "library/error.hpp"

//------------------------------------------------------------

// Core Classes
#include "core/primitive_wrapper.hpp"
#include "core/base.hpp"
#include "core/exp.hpp"
#include "core/precision.hpp"
#include "core/random_state.hpp"
#include "core/round_mode.hpp"
#include "core/version.hpp"

//------------------------------------------------------------

// Library Classes
#include "library/flags.hpp"
#include "library/global_parameters.hpp"

//------------------------------------------------------------

// Class Real
#include "real/real.hpp"
#include "real/arithmetic_operators.hpp"
#include "real/assignment.hpp"
#include "real/comparison.hpp"
#include "real/constructors.hpp"
#include "real/conversion.hpp"
#include "real/fits.hpp"
#include "real/is.hpp"
#include "real/non_static_methods.hpp"
#include "real/rounding.hpp"
#include "real/static_methods.hpp"
#include "real/to_string.hpp"
#include "real/stream.hpp"

//------------------------------------------------------------

// Functions
#include "core/numeric_function.hpp"
#include "functions/basic_arithmetic.hpp"
#include "functions/constants.hpp"
#include "functions/exponential.hpp"
#include "functions/hyperbolic.hpp"
#include "functions/integer_related.hpp"
#include "functions/inverse_hyperbolic.hpp"
#include "functions/inverse_trigonometric.hpp"
#include "functions/logarithmic.hpp"
#include "functions/miscellaneous.hpp"
#include "functions/random.hpp"
#include "functions/special.hpp"
#include "functions/trigonometric.hpp"

//------------------------------------------------------------

// Library Initialization
#include "library/numeric_functions_global_parameters_binder.hpp"
#include "initialization/default_parameters.hpp"
#include "initialization/initialization.hpp"

//------------------------------------------------------------

// Extra

/*
    #include <mpfrcpp/extra/beta.hpp>
    #include <mpfrcpp/extra/complex.hpp>
    #include <mpfrcpp/extra/fp_comparator.hpp>
    #include <mpfrcpp/extra/pminf.hpp>
    #include <mpfrcpp/extra/simple_functions.hpp>
    #include <mpfrcpp/extra/std_overloads.hpp>
*/

//------------------------------------------------------------

#undef INCLUDED_BY_MPFRCPP

//------------------------------------------------------------

#endif    // MPFRCPP
