//  Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef MOUSE_GRAPH_MAIN_H
#define MOUSE_GRAPH_MAIN_H

// initialize the GUI and run the main loop; only one instance is ever
// constructed so Main::instance is a convenience for retrieving it
#include <string>
#include <glibmm.h>
#include <gdkmm.h>
class Main
{
 public:
    Main(int &argc, char **&argv);
    ~Main();

    // singleton interface
    static Main &instance();
    
    void start_main_loop();
    void stop_main_loop();
    bool iterate_main_loop();

    static std::string get_data_path();

    void toggle_mouse_graphing();
    bool is_graphing();
    void graph_it();
 private:
    struct Impl;
    Impl *impl;


    bool version_appears_on_the_command_line;
    void on_show_popup(guint button, guint32 activate_time);
    void on_mouse_graphed(Cairo::RefPtr<Cairo::ImageSurface> surface);
    void remove_all_temporary_files();
};

#endif // MOUSE_GRAPH_MAIN_H
