# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import zipimport, imp, inspect

def load_module (name):
	"""This is a really simple function to provide an equivalent of imp/zipimport for logics
	Logics won't have to care about the fact that they're running from a zip file or from a flat file"""
	mod = None
	try:
		stack = inspect.stack()
		callerFile = stack[1][1]
		if ".zip" in callerFile:
			# Load_module is called from a zip...
			zipimporter = zipimport.zipimporter(callerFile.split(".zip")[0] + ".zip")
			mod = zipimporter.load_module(name)
		else:
			infos = imp.find_module(name)
			mod = imp.load_module(name, *infos)
	except:
		print "An exception occured in modimp"
	return mod

