# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import base_logic

class usersLogic(base_logic.Base):
	"""Implements a userlist watcher"""
	def __init__(self, core):
		self.core = core
		base_logic.Base.__init__(self, core)
		self.users = {}
		self.register ("get_users", self.get_users)
		
	def joinevent (self, channel, args):
		if self.users.has_key(channel):
			user = args[0].split("!")[0]
			self.users[channel].append(user)
	
	def kickevent (self, channel, args):
		if self.users.has_key(channel):
			user = args[0].split("!")[0]
			self.users[channel].remove(user)

	def leftevent (self, channel, args):
		if self.users.has_key(channel):
			user = args[0].split("!")[0]
			self.users[channel].remove(user)
	
	def renameevent (self, channel, args):
		# FIXME !
		if self.users.has_key(channel):
			self.users[channel].remove(args[0])
			self.users[channel].append(args[1])
	
	def botjoinevent (self, channel, args):
		self.users[channel] = []
		self.core.bot.IRC_send("WHO %s" % channel)
		
	def numanswer(self, args):
		if args[0] == 352:
			# args = [352, '#modularbot n=modularb ALille-251-1-32-30.w82-127.abo.wanadoo.fr irc.freenode.net ModularBot H :0 ModularBot']
			splitted = args[1].split(" ")
			channel = splitted[0]
			if splitted.index(self.core.bot.host) > 0:
				user = splitted[splitted.index(self.core.bot.host) + 1]
			else:
				user = splitted[4]
			if not user in self.users[channel]:
				self.users[channel].append(user)

	def get_users (self, channel):
		if self.users.has_key(channel):
			return self.users[channel]
		else:
			return []
	
	def Call_users (self, context):
		"""Shows the list of users on the channel"""
		if self.users.has_key(context.channel):
			context.say("Users : " + ", ".join(self.users[context.channel]))
		else:
			context.say("No information available")
	
	def Call_users_register (self, context):
		"""Shows the list of users on the channel, using the register..."""
		if self.register("get_users") != None:
			users = self.register("get_users")(context.channel)
			context.say("Users : " + ", ".join(users))
		else:
			context.say("Register get_users not found. Is the logic user loaded ?")