#*-*encoding: utf-8*-*
# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import base_logic,random

class symphLogic(base_logic.Base):
	"""Answers to some special requests starting with "!"... See !liste for the list"""
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
		self.singlemsg = {"!mars": ["Euh... Pour qui le mars $FROM ?"], \
						"!biere": ["Euh... Pour qui la bière $FROM ?"], \
						"!bonapp": ["$FROM souhaite à tout le monde un bon appétit.", "Bon ap' $FROM !"], \
						"!bye": ["Tchao $FROM", "Auf wiedersehen $FROM", "Bye $FROM", "C'est ça, casse toi $FROM"], \
						"!mdr": ["Hahahahaha !", "Wouaw wouaw, c'est super drôle !"], \
						"!limonade": ["$FROM: tu veux une limonade ?"], \
						"!dodo": ["T'es crevé $FROM ?"], \
						"!merci": ["Quelle politesse $FROM ! Remercier comme ça, c'est rare..."], \
						"!tarte": ["Gloup gloup :)"], \
						"!troll": ["$FROM: C'est vrai que ça pue le troll ici..."], \
						"!anglais": ["Win, the yes need the no to win, against the no"], \
						"!boulet": ["Boulet toi même $FROM !"]}
		self.doublemsg = {"!mars": ["$FROM offre un mars à $TO", "GRRRR ! $FROM pense qu'un mars ça aidera $TO"], \
						"!biere": ["Burp pour $TO :p"], \
						"!bonapp": ["$FROM souhaite à $TO un bon appétit.", "Bon ap' $TO !"], \
						"!bye": ["$FROM te dit Tchao $TO", "Salut $TO", "$FROM trouve que tu fais bien de te barrer, $TO"], \
						"!mdr": ["Hahahahaha ! $FROM trouve $TO plus drôle que Chirac, c'est dire"], \
						"!limonade": ["$FROM offre une limonade à $TO"], \
						"!dodo": ["$FROM souhaite à $TO une bonne nuit"], \
						"!troll": ["$TO, un troll ? Tu rigoles, c'est un blaireau surtout !"], \
						"!merci": ["$FROM remercie $TO du fond du coeur !"], \
						"!boulet": ["$FROM : bien d'accord ! Quel nase ce $TO"], \
						"!bashfr": ["$FROM conseille d'aller voir http://www.bashfr.org/?$TO"]}

	def globalCall (self, ctxte):
		message = ctxte.message.strip()
		user = ctxte.user
		if message == "!liste":
			self.bot.notice(user, self.singlemsg.keys())
		if len(message) == 0:
			return
		if message[0] == '!':
			if not " " in message:
				command = message
				arg = ""
			else:
				(command, arg) = message.split(" ",1)
				arg = arg.strip()
				command = command.strip()
			if "tlm" in arg.lower():
				ctxte.say("Vous en avez pas marre de mettre 'tlm' alors que ne rien mettre ça va aussi bien ?")
				return
			if len(arg) == 0 or not(self.doublemsg.has_key(command)):
				if self.singlemsg.has_key(command):
					texte = random.choice(self.singlemsg[command])
					texte = texte.replace("$FROM", user)
					texte = texte.replace("$TO", arg)
					ctxte.say(texte)
			else:
				if arg.lower() == self.bot.nickname.lower():
					ctxte.say("C'est à moi que tu parles ??")
				elif self.doublemsg.has_key(command):
					texte = random.choice(self.doublemsg[command])
					texte = texte.replace("$FROM", user)
					texte = texte.replace("$TO", arg)
					ctxte.say(texte)
		
