# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import base_logic

class nicksLogic(base_logic.Base):
	"""Implements a nick manager, associating a nick with a true name used in forts"""
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
		self.persistant["nicks"] = {}
		self.alias["I'm"] = "add_nick"
		self.register ("get_nick", self.get_nick)
	
	@return_dic
	def Call_nicks (self, context, message):
		"""Lists the registered nicks"""
		return self.persistant["nicks"]
		#for nick in self.persistant["nicks"].keys():
			#context.say("%s is %s" % (nick, self.persistant["nicks"][nick]))
	
	def get_nick (self, name):
		result = name
		for given_name in self.persistant["nicks"].values():
			if given_name.lower() == name.lower():
				result = self.persistant["nicks"].keys()[self.persistant["nicks"].values().index(given_name)]
		return result
	
	def add_nick (self, context, message):
		"""Adds one nick in the list"""
		if self.persistant["nicks"].has_key(context.user) or message in self.persistant["nicks"].values():
			context.say("%s : http://www.amishrakefight.org/gfy" % context.user)
		else:
			self.persistant["nicks"][context.user] = message
			self.save()
	
	@admin
	def Call_del_nick (self, context, message):
		"""Remove one nick"""
		if not self.persistant["nicks"].has_key(message):
			context.say("%s is not registered" % message)
		else:
			del(self.persistant["nicks"][message])
			self.save()
