# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import pickle

class Base:	
	def __init__(self, core):
		self.persistant = {}
		self.name = self.__class__.__name__
		self.name = self.name[:self.name.find("Logic")]
		self.core_register = core.register
		self.alias = {}
		self.bot = core.bot
	def register (self, name, fonction = None):
		return self.core_register(name, self.name, fonction)
	def save (self):
		if len(self.persistant) == 0:
			return
		print "Saving persist for %s..." % self.name
		pickle.dump(self.persistant, open("persist_%s.sav" % self.name,'w'))
	def load (self):
		try:
			new_persistant = pickle.load(open("persist_%s.sav" % self.name))
			for key in new_persistant.keys():
				self.persistant[key] = new_persistant[key]
		except IOError:
			pass