# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import base_logic

class notesLogic(base_logic.Base):
	"""Implements a kind of postit for IRC :)"""
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
		self.persistant["notes"] = {}
	
	def Call_note (self, context, message):
		"""Shows the note given in argument"""
		if self.persistant["notes"].has_key(message):
			context.say (self.persistant["notes"][message])
		else:
			context.say ("Note %s not found" % message)
			
	def Call_addnote (self, context, message):
		"""Adds a note... Arguments : notename notemessage"""
		if message == "":
			context.say ("Please give a note name and a message")
		else:
			try:
				(name, message) = message.split(" ", 1)
			except ValueError:
				context.say ("No message given")
				return
			if self.persistant["notes"].has_key(name):
				context.say ("Erasing current note")
			self.persistant["notes"][name] = message
			self.save()
	def Call_delnote (self, context, message):
		"""Remove the given note"""
		if self.persistant["notes"].has_key(message):
			del self.persistant["notes"][message]
			context.say ("That's done")
			self.save()
		else:
			context.say ("Note %s not found" % message)
	
	def Call_listnotes (self, context, message):
		"""Lists the available notes"""
		if len(self.persistant["notes"].keys()) == 0:
			context.say ("No note available")
		else:
			result = ""
			for note in self.persistant["notes"].keys():
				result += note + " ; "
			result = result[:-2]
			context.say (result)