# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import imp, time, threading, Context, rightsManager, os, zipimport, sys
from decorators import *

class Core:
	def __init__(self, bot, config):
		sys.path.append(os.getcwd() + "/logics")
		self.config = config
		self.rights = rightsManager.RightsManager(config.rights)
		self.bot = bot
		self.logics = {}
		self.registers = {}
		self.events = {"joinevent": {}, "kickevent": {}, "leftevent": {}, "renameevent": {}, "modeevent": {}, "numanswer": {}, "botjoinevent": {}}
		self.globalCalls = {}
		self.commands = {}
		self.bot.threads = {}
		self.open_logic("admin")
		self.last_arg = ""
		for module in config.logics_startup:
			self.open_logic(module)
	
	def register (self, name, module, fonction = None):
		if fonction == None:
			for module in self.registers.values():
				if module.has_key(name):
					return module[name]
			return None
		else:
			if not(self.registers.has_key(module)):
				self.registers[module] = {}
			self.registers[module][name] = fonction
	
	def close_logic (self, name):
		if self.logics.has_key(name):
			self.logics[name].save()
			for event_calls in self.events.values():
				if event_calls.has_key(name):
					del event_calls[name]
			if "__del__" in dir(self.logics[name]):
				self.logics[name].__del__()
			if self.globalCalls.has_key(name):
				del self.globalCalls[name]
			for command_tuple in self.commands.items():
				if command_tuple[1][0] == name:
					del self.commands[command_tuple[0]]
			if self.registers.has_key(name):
				del self.registers[name]
			del self.logics[name]
			return True
		else:
			return False
	
	def open_logic(self, name):
		if "." in name:
			return False
		result = False
		self.close_logic(name)
		try:
			if os.path.isfile("logics/%sLogic.py" % name):
				print "Opening logic from logics/%sLogic.py" % name
				new_logic_mod = imp.load_source("", "logics/%sLogic.py" % name)
			elif os.path.isfile("%sLogic.py" % name):
				print "Opening OBSOLETE logic from %sLogic.py" % name
				new_logic_mod = imp.load_source("", name + "Logic.py")
			else:
				print "Opening logic from logics/%s.zip" % name
				zipdemo = zipimport.zipimporter("logics/%s.zip" % name)
				new_logic_mod = zipdemo.load_module(name + "Logic")
			self.logics[name] = getattr(new_logic_mod, name + "Logic")(self)
			self.logics[name].load()
			for event in self.events.keys():
				if hasattr(self.logics[name], event):
					self.events[event][name] = getattr (self.logics[name], event)
			for attr in dir(self.logics[name]):
				if attr.startswith("Call_"):
					self.commands[attr[5:]] = [name, attr]
			for alias in self.logics[name].alias.keys():
				self.commands[alias] = [name, self.logics[name].alias[alias]]
			if "globalCall" in dir(self.logics[name]):
				self.globalCalls[name] = self.logics[name].globalCall
			result = True
		except:
			infos = sys.exc_info()
			sys.excepthook(infos[0], infos[1], infos[2])
		return result
	
	def event (self, event, channel, args):
		if self.events.has_key (event):
			for call in self.events[event].values():
				if channel != "":
					call(channel, args)
				else:
					call(args)
	
	def has_exec_right (self, user, logic, function):
		if function.startswith("Call_"):
			function = function[5:]
		if self.rights.logged_in(user):
			print "The user is logged in, ok"
			return self.rights.has_right(user, "module:%s" % logic) or self.rights.has_right(user, "function:%s" % function) or self.rights.is_admin(user)
		else:
			return False
	
	def exec_commande (self, ctxte, command):
		command = command.strip()
		if command == "":
			return
		if self.commands.has_key(command):
			logic = self.logics[self.commands[command][0]]
			cmd_func = getattr(logic, self.commands[command][1])
			admin = self.has_exec_right(ctxte.user, self.commands[command][0], self.commands[command][1])
			if hasattr(cmd_func, "is_admin") and not admin :
				ctxte.say("The command %s is an admin command" % self.commands[command][1])
				return
			ctxte.cmd_func = cmd_func
			ctxte.is_admin = admin
			ctxte.launch()
		else:
			ctxte.say("Command %s not found" % command)
	
	
	# Hooks return "" for an error, nothing when the hook is not concerned, the message without the hook when it applies.
	def hook_time (self, ctxte, message):
		if message.startswith("time "):
			ctxte.timing = True
			return message[4:].strip()
		
	def hook_notice (self, ctxte, message):
		if message.startswith("notice "):
			ctxte.noticing = True
			return message[6:].strip()
		
	def hook_grep (self, ctxte, message):
		if message.startswith("grep "):
			message = message[5:].strip()
			if not message.startswith('"'):
				ctxte.say('Usage : grep "txt" command')
				return ""
			else:
				i = 1
				while i < len(message):
					if message[i] == '"':
						break
					i += 1
				if i == len(message):
					ctxte.say('Usage : grep "txt" command')
					return ""
				else:
					criteria = message[1:i]
					command = message[i+1:].strip()
					if len(command) == 0:
						ctxte.say('Usage : grep "txt" command')
					else:
						ctxte.grep = criteria
						return command

	def answer(self, ctxte):
		for call in self.globalCalls.values():
			call(ctxte)
		if ctxte.message.startswith(self.bot.nickname) and not ctxte.stop:
			# Set the right message value now
			ctxte.message = ctxte.message[len(self.bot.nickname) + 1:].strip()
			message = ctxte.message
			hooks = ["time", "notice", "grep"]
			while 1:
				tocontinue = False
				for hook in hooks:
					result = getattr(self, "hook_" + hook)(ctxte, message)
					if result == "":
						return
					elif result != None:
						tocontinue = True
						hooks.remove(hook)
						message = result
						ctxte.message = message
				if not tocontinue or len(hooks) == 0:
					break
			while "&&" in message:
					message = message.replace("&&", "&")
			while " & " in message:
				message = message.replace(" & ", "&")
			if " " in message:
				[command, ctxte.command_args] = message.split(" ",1)
				if ctxte.command_args in ["*", "!*"]:
					ctxte.command_args = self.last_arg
				else:
					self.last_arg = ctxte.command_args
			else:
				command = message
				ctxte.command_args = ""
			if "&" in command:
				commands = command.split("&")
				for command in commands:
					print "executing", command
					self.exec_commande(ctxte, command)
			else:
				print "executing", command
				self.exec_commande(ctxte, command)
