# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import base_logic

class todoLogic(base_logic.Base):
	"""Implements a TODO list"""
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
		self.persistant["TODO"] = []
	def Call_TODO (self, context, message):
		"""If called with an argument, TODO adds this argument as a new TODO item.
		If called without argument, TODO lists all the TODO items"""
		if message != "":
			self.persistant["TODO"].append("%s (%s)" % (message, context.user))
			context.say( "Saved")
		else:
			texte = ""
			for item in self.persistant["TODO"]:
				if (len(texte) + len(item)) > 400:
					context.say(texte)
					texte = ""
				texte += item + " ; "
			if texte != "":
				context.say(texte)
		self.save()
	def Call_DONE (self, context):
		"""Remove the given TODO item from the TODO list (the user who reported the item is the only allowed to remove it"""
		for msg in self.persistant["TODO"]:
			if msg[:msg.rfind("(")-1] == context.command_args:
				self.persistant["TODO"].remove(msg)
		self.save()
