# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import base_logic, time, sys

class penduLogic(base_logic.Base):
	"""Implements a "pendu" game"""
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
		self.end_game()
	
	def Call_startPendu (self, context, message):
		"""Starts a game"""
		message = message.strip()
		if message == "":
			context.say("Empty word ?")
		elif self.word == "":
			self.word = message
		else:
			context.say("Game already launched, please end it before")
	
	def end_game (self, channel = ""):
		if channel != "":
			self.bot.say(channel, "The word was : %s" % self.word)
		self.word = ""
		self.mistakes = 0
		self.said = []
	
	def Call_suggest (self, context, message):
		"""Suggest a letter or a word"""
		if len(message) > 1:
			if len(message) == len(self.word):
				if message == self.word:
					context.say("%s: congrats, you found it was %s" % (context.user, self.word))
				else:
					context.say("%s: try again" % context.user)
					mistakes += 1
			else:
				context.say("%s: you stupid ! Your proposition doesn't even have the right characters count !" % context.user)
				mistakes += 1
		elif len(message) == 0:
			context.say("%s: empty suggestion ?" % context.user)
		else:
			if message in self.said:
				context.say("%s: already submitted..." % context.user)
			elif message in self.word:
				context.say("%s: right..." % context.user)
				self.said.append(message)
			else:
				context.say("%s: wrong..." % context.user)
				self.said.append(message)
			result = ""
			for char in self.word:
				if char in self.said:
					result += char
				else:
					result += "-"
			if result == self.word:
				context.say("Game won")
				self.end_game(context.channel)
			else:
				context.say(result)
		if self.mistakes > 10:
			context.say("Game lost")
			self.end_game(context.channel)

	@admin
	def Call_endPendu (self, context, message):
		"""Finish a game"""
		self.end_game(context.channel)