# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import base_logic, time

def get_hour ():
	liste = time.localtime()
	msg = "%2d:%2d" % (liste[3], liste[4])
	return msg.replace(" ", "0")

def simplify_name (name):
	return name[:name.find("!")]

class logLogic(base_logic.Base):
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
	
	def globalCall (self, user, channel, message):
		print "%s <+%s> %s" % (get_hour(), user, message)
	def kickevent (self, channel, args):
		print "%s -!- %s was kicker from %s by %s [%s]" % (get_hour(), args[0], args[1], args[2], args[3])
	def joinevent (self, channel, args):
		print "%s -!- %s [~%s@nowhere] has joined %s" % (get_hour(), args[0], args[0], args[1])
	def leftevent (self, channel, args):
		print "%s -!- %s [~%s@nowhere] has quit [I don't know]" % (get_hour(), args[0], args[0])
	def renameevent (self, channel, args):
		self.bot.say(channel, "%s renamed to %s " % (args[0], args[1]))
	def modeevent (self, channel, args):
		def set_str (status):
			if status: return "+"
			return "-"
		try:
			print "%s -!- mode/%s [%s%s %s] by %s" % (get_hour(), args[1], set_str(args[2]), args[3], str(args[4][0]), simplify_name(args[0]))
		except IndexError:
			print "%s -!- mode/%s [%s%s] by %s" % (get_hour(), args[1], set_str(args[2]), args[3], simplify_name(args[0]))

"""kickevent => [user, channel, kicker, reason]
joinevent => [user, channel]
leftevent => [user, channel]
renameevent => [old, new]
modeevent => [user, channel, set, modes, args]"""

"""12:33 -!- clemux_ [~clemux@3ffe:80ee:344b:0:0:0:0:0] has joined #fnux
12:43 <+clemux> !bonapp PieD
13:24 -!- clemux was kicked from #fnux by PieD [c'est un exemple]
13:42 -!- Testator [~Testator@ALille-251-1-69-101.w82-127.abo.wanadoo.fr] has quit [Remote closed the connection]

12:47  * phh se fait une playlist du plus endormant au plus réveillant"""