#!/usr/bin/python
# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


from IRCClient import IRCClient
import imp, IRC_conf, time, inspect

config = IRC_conf.IRCConf("bot_conf.xml")

class ModularBot(IRCClient):
	def __init__(self, host, port, nick, ident, realname):
		IRCClient.__init__(self, host, port, nick, ident, realname)
		self.noticing = False
		self.grep = ""
		self.nickname = config.nick
		for attr in ["versionNum", "versionName", "versionEnv"]:
			setattr(self, attr, getattr(config, attr))
		self.core_mod = imp.load_source("", "Core.py")
		self.logic = self.core_mod.Logic(self, config)
		self.versionString = "%s@%s - %s" % (self.versionName, self.versionEnv, self.versionNum)

	def privmsg(self, user, channel, msg):
		if channel.lower() == self.nickname.lower():
			msg = self.nickname + ": " + msg
			channel = user.split("!", 1)[0]
		if msg == "%s: CORE_RELOAD" % self.nickname:
			if self.logic.rights.is_core_admin(user):
				print "------CORE RELOAD------"
				self.core_mod = imp.load_source("", "Core.py")
				self.logic = self.core_mod.Logic(self, config)
				return
		self.logic.answer(user, channel, msg)
	
	def say (self, channel, message):
		#print "Appel venant de ", inspect.stack()[1][3]
		if len(message) > 450:
			broke = False
			part1 = ""
			part2 = ""
			try:
				for pos in range(350,len(message)):
					if message[pos] in [".", ",", ";", ":"] and message[pos+1] == " ":
						broke = True
						part1 = message[:pos+2]
						part2 = message[pos+2:]
						break
			except IndexError:
				pass
			if not broke or len(part1) > 450:
				for pos in range(350,len(message)):
					if message[pos] == " ":
						broke = True
						part1 = message[:pos]
						part2 = message[pos:]
						break
			if broke:
				if self.noticing:
					IRCClient.notice(self, channel, part1)
				else:
					IRCClient.say(self, channel, part1)
				self.say(channel, part2)
				return
		
		if self.noticing:
			IRCClient.notice(self, channel, message)
		else:
			IRCClient.say(self, channel, message)
	
	def signedOn(self):
		print "joining ", config.channel
		self.join(config.channel)
	def joined(self, channel):
		for logon in config.logons:
			eval(logon)
	def userJoined(self, user, channel):
		self.logic.event("joinevent", channel, [user, channel])
	def userKicked(self, user, channel, kicker, reason):
		self.logic.event("kickevent", channel, [user, channel, kicker, reason])
	def userRenamed(self, oldname, newname):
		self.logic.event("renameevent", "", [oldname, newname])
	def userLeft(self, user, channel):
		self.logic.event("leftevent", channel, [user, channel])
	def modeChanged (self, user, channel, set, modes, args):
		self.logic.event("modeevent", channel, [user, channel, set, modes, args])
	def numericAnswer(self, cmd_number, line):
		self.logic.event("numanswer", "", [cmd_number, line])

if __name__ == "__main__":
	client = ModularBot (config.url, config.port, config.nick, config.ident, config.realname)
	client.connect()
	client.run()