# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import imp, time, threading, Context
from decorators import *

class Logic:
	def __init__(self, bot, config):
		self.modules_admins = config.modules_admins
		self.bot = bot
		self.logics = {}
		self.registers = {}
		self.events = {"joinevent": {}, "kickevent": {}, "leftevent": {}, "renameevent": {}, "modeevent": {}, "numanswer": {}}
		self.globalCalls = {}
		self.commands = {}
		self.bot.threads = {}
		self.open_logic("admin")
		self.grep = ""
		self.noticing = False
		self.timing = False
		self.last_arg = ""
		for module in config.logics_startup:
			self.open_logic(module)
	
	def register (self, name, module, fonction = None):
		if fonction == None:
			for module in self.registers.values():
				if module.has_key(name):
					return module[name]
			return None
		else:
			if not(self.registers.has_key(module)):
				self.registers[module] = {}
			self.registers[module][name] = fonction
	
	def close_logic (self, name):
		if self.logics.has_key(name):
			self.logics[name].save()
			for event_calls in self.events.values():
				if event_calls.has_key(name):
					del event_calls[name]
			if "__del__" in dir(self.logics[name]):
				self.logics[name].__del__()
			if self.globalCalls.has_key(name):
				del self.globalCalls[name]
			for command_tuple in self.commands.items():
				if command_tuple[1][0] == name:
					del self.commands[command_tuple[0]]
			if self.registers.has_key(name):
				del self.registers[name]
			del self.logics[name]
			return True
		else:
			return False
	
	def open_logic(self, name):
		if "." in name:
			return False
		result = False
		self.close_logic(name)
		try:
			new_logic_mod = imp.load_source("", name + "Logic.py")
			self.logics[name] = getattr(new_logic_mod, name + "Logic")(self)
			self.logics[name].load()
			for event in self.events.keys():
				if hasattr(self.logics[name], event):
					self.events[event][name] = getattr (self.logics[name], event)
			for attr in dir(self.logics[name]):
				if attr.startswith("Call_"):
					self.commands[attr[5:]] = [name, attr]
			for alias in self.logics[name].alias.keys():
				self.commands[alias] = [name, self.logics[name].alias[alias]]
			if "globalCall" in dir(self.logics[name]):
				self.globalCalls[name] = self.logics[name].globalCall
			result = True
		except IOError:
			pass
		return result
	
	def event (self, event, channel, args):
		if self.events.has_key (event):
			for call in self.events[event].values():
				if channel != "":
					call(channel, args)
				else:
					call(args)
	
	def exec_commande (self, user, channel, message, command, command_args):
		if command == "":
			return
		if self.commands.has_key(command):
			logic = self.logics[self.commands[command][0]]
			cmd_func = getattr(logic, self.commands[command][1])
			if hasattr(cmd_func, "is_admin") and not user.lower() in self.modules_admins:
				self.bot.say(channel, "The command %s is an admin command" % self.commands[command][1])
				return
			ctxte = Context.Context(cmd_func, user, channel, message, self.bot, command_args)
			ctxte.grep = self.grep
			ctxte.noticing = self.noticing
			ctxte.timing = self.timing
			ctxte.launch()
		else:
			self.bot.say(channel, "Command %s not found" % command)
	
	def answer_internal (self, user, channel, message):
		print (user, channel, message)
		if message.startswith("time "):
			self.timing = True
			message = message[4:].strip()
			self.answer_internal(user, channel, message)
		elif message.startswith("notice ") and not self.bot.noticing:
			self.noticing = True
			message = message[6:].strip()
			self.answer_internal(user, user, message)
		elif message.startswith("grep "):
			message = message[5:].strip()
			if not message.startswith('"'):
				self.bot.say(channel, 'Usage : grep "txt" command')
			else:
				i = 1
				while i < len(message):
					if message[i] == '"':
						break
					i += 1
				if i == len(message):
					self.bot.say(channel, 'Usage : grep "txt" command')
				else:
					criteria = message[1:i]
					command = message[i+1:].strip()
					if len(command) == 0:
						self.bot.say(channel, 'Usage : grep "txt" command')
					else:
						self.grep = criteria
						self.answer_internal(user, channel, command)
		else:
			if " " in message:
				[command, command_args] = message.split(" ",1)
				if command_args in ["*", "!*"]:
					command_args = self.last_arg
				else:
					self.last_arg = command_args
			else:
				command = message
				command_args = ""
			if "&" in command:
				while " & " in message:
					message = message.replace(" & ", "&")
				while "&&" in command:
					command = command.replace("&&", "&")
				commands = command.split("&")
				for command in commands:
					self.exec_commande(user, channel, message, command.strip(), command_args)
			else:
				self.exec_commande(user, channel, message, command, command_args)
			self.grep = ""
			self.noticing = False
			self.timing = False

	def answer(self, user, channel, message):
		user = user.split('!', 1)[0]
		for call in self.globalCalls.values():
			call(user, channel, message)
		if message.startswith(self.bot.nickname):
			# Remove the bot name
			message = message[len(self.bot.nickname) + 1:].strip()
			self.answer_internal(user,channel,message)
