# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import base_logic
from decorators import *

class adminLogic(base_logic.Base):
	"""Contains the logics related calls"""
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
		self.core = core
	@admin
	def Call_load (self, user, channel, message):
		"""Load a logic"""
		if not self.core.open_logic(message):
			self.bot.say(channel, "Unable to load %s" % message)
		else:
			self.bot.say(channel, "Logic loaded")
	
	@admin
	def Call_save (self, user, channel, message):
		"""Save all the persistent dictionnaries"""
		for logic in self.core.logics.values():
			logic.save()
	
	@admin
	def Call_unload (self, user, channel, message):
		"""Unload a logic"""
		if self.core.close_logic(message):
			self.bot.say(channel, "Logic %s closed" % message)
		else:
			self.bot.say(channel, "Logic %s is not loaded" % message)
	
	@admin
	def Call_modules (self, user, channel, message):
		"""List all opened logic"""
		result = "Logics loaded : "
		for logic_name in self.core.logics.keys():
			result += logic_name + " ; "
		self.bot.say(channel, result[:-2])
	
	@admin
	def Call_join (self, user, channel, message):
		self.bot.join (message)
	
	@admin
	def Call_leave (self, user, channel, message):
		if message.startswith("#"):
			(chan, reason) = message.split(" ", 1)
		else:
			chan, reason = channel, message
		self.bot.leave(chan, reason)

	def Call_help (self, user, channel, message):
		"""If called with an argument (a call name), shows help about this call, else lists
		all available calls"""
		if message.strip() == "":
			self.bot.say(channel, "Available commands :")
			for logic in self.core.logics.keys():
				liste = []
				for fct in dir(self.core.logics[logic]):
					if fct.startswith("Call_"):
						name = fct[5:]
						if hasattr(getattr(self.core.logics[logic], fct), "is_admin"):
							name = "*%s*" % name
						if hasattr(getattr(self.core.logics[logic], fct), "threaded"):
							name = "T:%s" % name
						liste.append(name)
				for alias in self.core.logics[logic].alias:
					liste.append(alias)
				if len(liste) > 0:
					self.bot.say(channel, "In %s : %s" % (logic, str(liste)))
		else:
			command = message.strip()
			if not self.core.commands.has_key(command):
				self.bot.say(channel, "Command %s not found" % command)
			else:
				logic = self.core.logics[self.core.commands[command][0]]
				cmd_func = getattr(logic, self.core.commands[command][1])
				if cmd_func.__doc__ == "" or cmd_func.__doc__ == None:
					self.bot.say(channel, "The command %s is not documented" % command)
				else:
					self.bot.say(channel, cmd_func.__doc__)
	
	def Call_help_logic (self, user, channel, message):
		"""Gives informations about a logic"""
		msg = message.strip()
		if msg == "":
			self.bot.say (channel, "A logic name is required as argument")
		else:
			if self.core.logics.has_key(msg):
				logic = self.core.logics[msg]
				if logic.__doc__ == "" or logic.__doc__ == None:
					self.bot.say(channel, "The logic %s is not documented" % msg)
				else:
					self.bot.say(channel, logic.__doc__)
			else:
				self.bot.say (channel, "No logic loaded with the name %s" % msg)
