# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import base_logic
from threading import Thread, Event
from SimpleXMLRPCServer import SimpleXMLRPCServer

class servThread (Thread):
	def __init__(self, server):
		Thread.__init__(self)
		self.stop = Event()
		self.server = server
	
	def run (self):
		while not self.stop.isSet():
			self.server.handle_request()

class RPCLogic(base_logic.Base):
	class RPCHandler:
		def __init__ (self, core):
			self.core = core
		
		def modules (self):
			return self.core.logics.keys()
		
		def unload (self, name):
			return self.core.close_logic(name)
		
		def load (self, name):
			return self.core.open_logic(name)
				
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
		self.server = SimpleXMLRPCServer(("10.92.21.18", 8000))
		self.thread = servThread(self.server)
		self.server.register_instance(self.RPCHandler(core))
		self.server.register_introspection_functions()
	
	def Call_launchServer(self, user, channel, args):
		self.bot.say (channel, "Server started...")
		self.thread.start()
		
	def __del__ (self):
		print "Stopping RPCServer"
		self.thread.stop.set()