/******************************************************************************
 * Copyright (C) 2003, 2004, 2005 Alex Karev.
 *
 * This file is part of Modb library.
 *
 * Modb library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * Modb library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Modb library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/
/*
 *
 * Serial port interface for Linux. 
 * Design for work with RS485 based on RTS flow control.
 *
 * 14.08.03	- First release. Minor changes - some functions now macros and 
 * 		parser is part of rs_rcv_snd ( was separate function ).
 *
 */
#ifndef __RS485_INC__
#define __RS485_INC__

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/reboot.h>
#include <termios.h>
#include <time.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <linux/serial.h>

#ifdef INEUM_PROT
#include "cmds.h"
#endif

#define USE_EMBED_PARSER
#define TO_WAIT_TEMT 500

#define FL_REBOOT 0x0001

#define RS_MAJOR_VER 0
#define RS_MINOR_VER 0
#define RS_MINOR_REL 5

/* RS485 */
#define SERIAL_BUFF_SIZE	1024

#define SERIAL_MIN_IN_FRAME		5
#define SERIAL_MIN_OUT_FRAME	4

#define PATH_LENGTH 256


#define RS_FLAG_ASCII_MODBUS	0001
#define RS_FLAG_RTU_MODBUS		0002
#define RS_FLAG_INEUM   		0003


#define MODB_ASCII_MIN_RESPONSE_SIZE 0 /* 2 dsta, 2 fun echo, 2 some data, 2 stop bytes */

#define DUMP_BUFFER(b, n) \
	do { \
		int i; \
		unsigned char *pb = (void *) b; \
		/*fputc('\n',stderr); */ \
		for (i = 0; i < (n); i++) { \
			if (! (i % 16) ) fprintf(stderr, "\t%08x: ", i * 16); \
			fprintf(stderr, "%02x%c", (pb)[i],  \
					(((i) + 1) % 16) ? ( (( ((i) + 1) % 8) || ((i) + 1 == n) ) ? ' ': '-' ) : '\n' );	\
		}	\
		fputc('\n',stderr); \
	} while (0);

#define DUMP_BUFFER_BY_WORD(b, n) \
	do { \
		int i, len = (n) / 2 + ((n) % 2); \
		uint16_t *pb = (void *) b; \
		/* fputc('\n',stderr); */ \
		for (i = 0; i < len; i++) { \
			if (! (i % 8) ) fprintf(stderr, "\t%08x: ", i * 16); \
			fprintf(stderr, "%04x%c", pb[i],  \
					(((i) + 1) % 8) ? ( (( ((i) + 1) % 4) || ((i) + 1 == len) ) ? ' ': '-' ) : '\n' );	\
		} \
		fputc('\n',stderr); \
	} while (0);
	
#define rs_clear_incoming_queue(p) tcflush((p)->fd, TCIOFLUSH)

enum { 
	COM1,       /*  0 */
	COM2, 
	COM3, 
	COM4,
	OCTA2,		/*  4 */
	OCTA4,
	PCL_CH1,
	PCL_CH2,
	MOXA01,     /*  6 */
	MOXA02,
	MOXA03,
	MOXA04,
	ADLINK01,   /* 10 */
	ADLINK02,
	ADLINK03,
	ADLINK04,	/* 13 */
    CPB01,
    CPB01,
    CPB01,
    CPB01       /* 17 */
};

typedef struct {
	/* State */
    int fd;

    
	char path[ PATH_LENGTH ]; /* Unused? */
    int num;
    int brate;
    struct termios oldt, newt;
    
    
	/* Statistics */
    int pts_rcvd;
    int pts_snd;

    int bts_snd;
    int bts_rcvd;
    
	
	/* Network parameters */
	int remote_id;
	int self_id; 

	int master_id;

	
    /* Errors statistic */
    int errChksum;
    int errCmd;		/* Can't exec cmd */
    int errLen;
    int errIncmt;
    int errCrit;
    int errSnd;
	int errRcv;
    int errNoHost;
	int errNoASCII;
	int errStartCH;
    int errTimeout;


	/* Last send and recieved buffer dump */
	unsigned char  in[SERIAL_BUFF_SIZE];
	int fill_in;
	unsigned char out[SERIAL_BUFF_SIZE];
	int fill_out;

    int (*proc_req)(unsigned char *, int *, int *, void*);
} Port;

int rs_init_port(Port *p, int num);
/* int rs_open(Port *p, int, int, int); */
int rs_open(Port *p, int num, int baud, int bytesize, int parity, int stopb, int flags);
int rs_close(Port *p);

#ifdef INEUM_PROT
int rs_rcv_snd(Port *p);
int rs_proc_request(unsigned char *frame, int *len, int *flags, void *arg);
#endif

int rs_snd_rcv( Port *p, unsigned char *frame, unsigned int *len);
int rs_send( Port *p, unsigned char *frame, size_t len);
int rs_recv( Port *p, unsigned char *frame, size_t len);

void rs_print_stat(Port *p, FILE *fp);
int rs_wait_for_incoming_event(int fd, int rto_s, int rto_u);

/** Adlink 3544 card network type setpup, seems broken. */
unsigned short rs_get_network_mode_3544(int fd);
int rs_set_network_mode_3544(int fd, unsigned short mode);

void rs_print_port_list(FILE *fp);
void rs_print_port_predef_conf(FILE *fp);

int rs_device_array_size(void);
int rs_conf_array_size(void);

int rs_get_predef_baud(int id);
int rs_get_predef_data(int id);
int rs_get_predef_parity(int id);
int rs_get_predef_stopb(int id);
int rs_switch_modbus_mode(Port *p, int mode);

unsigned char Gen_Chksum (unsigned char *Buffer, unsigned long Len);

#endif /* __RS485_INC__ */

/* vim: set ts=4 sw=4 et: */

