/*****************************************************************************
 *
 * Copyright (C) 2005 Alex Karev.
 *
 * This file is part of KP modules library.
 * 
 ****** vim: set ts=4 sw=4 et: ***********************************************/
#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>

#include "dbapi.h"
#include "mod.h"

#define N_ELS(a) (sizeof (a) / sizeof (a)[0])

enum {
	ANALOG_1,
	DISCRET_1,
	NUM_OF_TASKS
} TASK_ID;


static TaskArg arg[] = 
{
	{	
		.id = ANALOG_1, 
		.base = 0x100, 
		.type = 2, 
		.ma_f = 1,
		.delta = 100,
		.ch1  = 20,
		.task = AnalogAsync
	},
	{
		.id = DISCRET_1, 
		.base = 0x120, 
		.task = DiscretAsync
	}
};


static void
print_greeting(FILE *f)
{
	fprintf(f, "Running KP database tests.\nBuild on %s %s by Alex Karev. INEUM (C).\n", 
			__DATE__, __TIME__);
}

int
main(int argc, char *argv[])
{
	DB_ENV *env;
	char tag[TAG_NAME_LENGTH];
	const char *tag_fmt = "Analog%d";
	int i,res;
	pthread_t tid[NUM_OF_TASKS];

	INIT();
	(void) print_greeting(stdout);

#if 0
	if (env_open(&env, "data", 0)) {
		perror("env_open");
		return (-1);
	}
	
	
	for(i = 0; i < 10000; i++) {
		(void) sprintf(tag, tag_fmt, i);
		if (db_create_tag_rec(env, tag, TYPE_FLOAT_TAG, 
					&( (DataSource) { .modid = i % 3, .chid = i % 3}))) {
			break;
		}
	}

	(void) db_update_ds(env, 
			    &( (DataSource) { .modid = 1, .chid = 1}), 
			    &( (Tag){}) );
	
	if (env_close(env, 0)) {
		perror("env_close");
		return (-1);
	}
#endif


#if 1
	if (N_ELS(arg) != NUM_OF_TASKS) exit(1);
	
	for (i = 0; i < NUM_OF_TASKS; i++) {
		res = pthread_create(&tid[i], NULL, arg[i].task, &arg[i]);

		if (res) {
			perror(__func__);
			exit(1);
		}
	}

	for (i = 0; i < NUM_OF_TASKS; i++) {
		
		if (pthread_join(tid[i], NULL)) {
			perror(__func__);
			exit(1);
		}

	}
#endif
	
	return (0);
}


