#include <dos.h>
//#include <io.h>

#include <bios.h>
#include <stdio.h>
#include <conio.h>
//#include <fcntl.h>
//#include <sys\stat.h>

//#include <windows.h>
//#include <toolhelp.h>


//*****************************************************************
//砫 ࠩ  18

//⠭ 
#define	mav18_stadr		0x000
#define mav18_cmdadr    0x002
#define mav18_datadr	0x010
#define mav18_rdy		0x01
#define mav18_dat_num	18

unsigned mav18_data( //read mav data. return mav18 status:
//FFFF - -,  18 
//0FFF - ⠩- -    50ᥪ
//0000 - ᫥  ⥭  ࠩ 뢠   0000.
//		   ᫥  ७ ᮡ.
//		  ⠪ ᮡ⨩ - 砭 ८ࠧ  ᥬ 
unsigned port, //mav 18 baseport
unsigned data[]) { //pointer to array[18] of mav data
unsigned i, st;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if (inportb(port+2)&mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			for (i=0;i<16;data[i++]=0);	//data
			return 0x0fff; //if mav not acessible
		}
	}
	//read status
	outportb(port,0x03);
	inportb(port);			//"read" command
	outportb(port,mav18_stadr);
	inportb(port);			//address
	outportb(port,0xff);
	st=inportb(port);		//data
	outportb(port,0xff);
	st=st+(inportb(port)<<8);//data
	inport(port+4);			//end of read

	//reset status
	outportb(port,0x06);    //write enable command
	inportb(port);
	inport(port+4);        //end of commnad

	outportb(port,0x02);    //write command
	inportb(port);
	outportb(port,mav18_stadr);
	inportb(port);			//address
	outportb(port,0x00);
	inportb(port);			//
	outportb(port,0x00);
	inportb(port);			//
	inport(port+4);        //end of commnad

	//read reset status (check it for zero!)
	outportb(port,0x03);
	inportb(port);			//"read" command
	outportb(port,mav18_stadr);
	inportb(port);			//address
	outportb(port,0xff);
	i=inportb(port);		//data
	outportb(port,0xff);
	i|=inportb(port);		//data
	inport(port+4);			//end of read
	if (i) {	//if st!=0
		outportb(port+2,0);
		for (i=0;i<mav18_dat_num;data[i++]=0);	//data
		return 0xffff; 		//if mav absent or fault
	}

	//read data
	outportb(port,0x03);
	inportb(port);			//read command
	outportb(port,mav18_datadr);
	inportb(port);			//address
	for (i=0; i<mav18_dat_num; i++) {
		outportb(port,0xff);
		data[i]=inportb(port);		//low data
		outportb(port,0xff);
		data[i]=data[i]+(inportb(port)<<8);	//data
	}
	inportb(port+4);			//end of read

	outportb(port+2,0);			//free memory

	return st;
}

// , 祭 ࠬ஢ 
#define	mav18_cali_cmd  0x11 //७ ஢, 
#define	mav18_cals0_cmd 0x14 //⥬ ஢ ,   ()
#define	mav18_cals1_cmd 0x15 //⥬ ஢ 誠,   ()
#define	mav18_rst_cmd  	0x78 // , 
#define	mav18_dac_cmd  	0x33 //뢮 ⮪, 祭 (2  0-0FFF)
#define	mav18_burn_cmd 	0x41 //뢮 ⮢ ⮪, 1  (0-/1-)

unsigned mav18_cmd( //execute mav command. return mav18 status:
//FFFF -  18   ࠢ
//0FFF - ⠩- -    50ᥪ
//00FF - ⠩-  -  ਧ 砭 
unsigned port, //mav 18 baseport
char	 cmd, //command
char	 data[]) { //array[16] of parameters
//data[0] -  ᨢ  . 0, ᫨  ࠬ஢
//data[1]... - ࠬ
unsigned i,j, f, st;

	//write mav command
	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if (inportb(port+2)&mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			return 0x0fff; //if mav not acessible
		}
	}

	//write mav command and parameters
	outportb(port,0x06);    //write enable command
	inportb(port);
	inport(port+4);        //end of commnad

	outportb(port,0x02);    //write command
	inportb(port);
	outportb(port,mav18_cmdadr);
	inportb(port);			//address
	outportb(port,0x35);
	inportb(port);			//command flag
	outportb(port,cmd);
	inportb(port);			//command code
//	if (data[0]!=0)  //if parameters exist
	for (i=1; i<=data[0]; i++) {
		outportb(port,data[i]);
		inportb(port);			//parameters
	}

	inportb(port+4);        //end of command
	outportb(port+2,0);		//end of mav access

	//wait for "command accepted" flag
	for (j=0; j<1000; j++) { //2 sec time-out
		delay(2);
		inport(port+2);
		for (i=0; i<0xffff; i++) {
			if ((inportb(port+2)&0x01)==mav18_rdy) break; //if mav accessible
			if (i>50000) {
				inport(port+4);				//end of read
				outportb(port+2,0);
				return 0x0fff; //if mav not acessible
			}
		}

		//read status
		outportb(port,0x03);
		inportb(port);				//"read" command
		outportb(port,mav18_stadr);
		inportb(port);				//address
		outportb(port,0xff);
		st=inportb(port);			//low status
		outportb(port,0xff);
		st=st+(inportb(port)<<8);	//high status
		outportb(port,0xff);
		f=inportb(port);			//command flag

		inport(port+4);				//end of read
		outportb(port+2,0);         //end of mav access

		if ((f==0)||(f==0x53)) return st; //if command OK
		if ((f!=0x35)||(st==0xffff)) return 0xffff;	//mav not exist
	} //for

	return 0x00ff; //command time-out
}

// ࠩ
//***************************************************************



unsigned mav18_rd( //read mav byte. return mav18 status:
//FFFF - -,  18 
//0FFF - ⠩- -    50ᥪ
unsigned port, //mav 18 baseport
unsigned adr, //mav memory address
unsigned char *dat_p) {  //pointer to mav byte
unsigned i, st;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if ((inportb(port+2)&0x01)==mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			return 0x0fff; //if mav not acessible
		}
	}
	//read byte
	st=(adr & 0x0100)>>8-3;	//high bit of address
	outportb(port,0x03|st);
	inportb(port);			//"read" command
	outportb(port,adr);
	inportb(port);			//address
	outportb(port,0xff);
	*dat_p=inportb(port);		//data

	inport(port+4);			//end of read
	outportb(port+2,0);		//end of mav access

	return 0;
}


unsigned mav18_st_wr( //write mav memory status. return mav18 status:
//FFFF - -,  18 
//0FFF - ⠩- -    50ᥪ
unsigned port, //mav 18 baseport
unsigned char dat) { //status byte
unsigned i;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if ((inportb(port+2)&0x01)==mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			return 0x0fff; //if mav not acessible
		}
	}

	//write status
	outportb(port,0x06);    //"write enable" command
	inportb(port);
	inport(port+4);        //end of commnad

	outportb(port,0x01);
	inportb(port);          //"write status" command
	outportb(port,dat);
	inportb(port);			//status
	inport(port+4);        //end of commnad

	outportb(port+2,0);		//end of mav access

	return 0;
}


unsigned mav18_st_rd( //read mav memory status:
//FFFF - -,  18 
//0FFF - ⠩- -    50ᥪ
//00XX - memory status
unsigned port //mav 18 baseport
) {
unsigned i;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if ((inportb(port+2)&0x01)==mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			return 0x0fff; //if mav not acessible
		}
	}

	//read status
	outportb(port,0x05);
	inportb(port);          //"read status" command
	outportb(port,0xFF);
	i=inportb(port);		//status
	inport(port+4);        	//end of commnad

	outportb(port+2,0);		//end of mav access

	return i;
}


unsigned mav18_wr( //write mav byte. return mav18 status:
//FFFF - -,  18 
//0FFF - ⠩- -    50ᥪ
unsigned port, //mav 18 baseport
unsigned adr, //mav memory address
unsigned char dat) { //mav byte
unsigned i, st, stm;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if ((inportb(port+2)&0x01)==mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			return 0x0fff; //if mav not acessible
		}
	}


//	stm=mav18_st_rd(port)&0x0C;	//store memory status
//	mav18_st_wr(port,0x00);		//reset memory protection

	//write byte
	outportb(port,0x06);    	//"write enable" command
	inportb(port);
	inport(port+4);        		//end of commnad

	st=(adr & 0x0100)>>8-3;		//high bit of address
	outportb(port,0x02|st);
	inportb(port);          	//"write" command
	outportb(port,adr);
	inportb(port);				//address
	outportb(port,dat);
	inportb(port);				//data
	inport(port+4);         	//end of commnad

//	mav18_st_wr(port,stm);		//set memory protection

	outportb(port+2,0);			//end of mav access

	return 0;
}

unsigned byte_in(void) {  //input 2-digit hex
unsigned char hex[]={"0123456789ABCDEF"};
unsigned char a, sym, i;

	a=bioskey(0)&0xFF; //input char
	printf("%c",a);
	if (a>=0x60) a=a&0x5F;
	for (i=0; i<16; i++) if (a==hex[i]) break;
	if (i>=16) return a<<8;
	sym=i<<4;
	a=bioskey(0)&0xFF; //input char
	printf("%c",a);
	if (a>=0x60) a=a&0x5F;
	for (i=0; i<16; i++) if (a==hex[i]) break;
	if (i>=16) return a<<8;
	sym=sym|i;

	return sym;
}



int printb(int width, long unsigned dat) { //print word binary
char str_dat[49];
int i;

	if (width>48) return -1;

	str_dat[width]=0;
	for (i=width-1; i>=0; i--) {
		if ((dat&0x0001)!=0) str_dat[i]=0x31;
		else str_dat[i]=0x30;
		dat=dat>>1;
	}
	printf(" %s",str_dat);

	return 0;
}




void main(void) {
int i, i0, j, ch[10], ch1, ma_f;
unsigned type, mode, base,stat,tok, flag, delta, adr;
unsigned char a, data_b[60], cmd;
unsigned data[20], data1[20];
long da, da1;


	printf("\n               ***     .1.0 ***\n : ");
	scanf("%x",&base);
	stat=mav18_data(base,data); //check, if card present
	if (stat>=0xFFF) { //something wrong
		if (stat==0xFFF)
		printf("\n訡! Time-out ");
		else if (stat==0xFFFF)
		printf("\n訡!   ࠢ ");
	}

	while (1) {
		printf("\n (1-७, 2-뢮, 3-, 4-ࢨ): ");
		scanf("%d",&mode);
		i0=0;
		switch (mode) {
		case 1: {
			printf("뢮 (1-, 2-): ");
			scanf("%d",&type);
			if (type!=2) type=1;
			if (type==1) {
			//only 4 channels for binary mode
				printf("  (4 !): ");
				scanf("%d %d %d %d",&ch[0],&ch[1],&ch[2], &ch[3]);
			} else {
				printf(" ஢ન: ");
				scanf("%d",&ch1);
				printf("ண ஢ન (0-65535): ");
				scanf("%u",&delta);
				printf("뢮 (0-, 1-, 2-): ");
				scanf("%u",&ma_f);
			}
			stat=mav18_data(base,data); //input data
			for (i=0; i<mav18_dat_num; i++) data1[i]=data[i]; //remember data
			flag=1;

			while (1) {
				stat=mav18_data(base,data); //input data
				if (type==2) {
					printf ("\nst=%04X ",stat);
					for (i=1; i<=mav18_dat_num; i++) {
						da=data[i-1];
						da1=(unsigned) data1[i-1];
						data1[i-1]=da;
						if ((ch1==0)||(i==ch1)){
							if ((da>da1+delta)||
								(da1>da+delta)) flag=0;
						}
						switch (ma_f) {
						case 1: { //mA
							if (i<=16)
							printf ("% 8.4f",float(1280)/65535*da/49.9);
							else printf ("% 8.2f",float(1280)/65535*(int)da);
						break;}
						case 0: { //units
							if (i<=16) printf ("% 8ld",da);
							else printf ("% 8d",da);
						break;}
						default: { //mV
							if (i<=16)
							printf ("% 8.2f",float(1280)/65535*da);
							else printf ("% 8.2f",float(1280)/65535*(int)da);
						}
						} //switch (ma_f)
					} //for(i=1;
				} else {
					a=0x0d;
					printf ("%cst=%04X ",a,stat);
					for (i=0; i<4; i++) printb (16,data[ch[i]-1]);
				}

				if ((stat!=0)&&((stat&0x0008)==0)) flag=0;

				if (flag==0) { //wait for key pressed, if data are broken
					while (kbhit()==0) ; //loop while key not pressed
					flag=1;
					a=getch()&0xff;
					if ((a==*"e")||(a==*"E")) break;
				}

				if (kbhit()!=0) {//if key pressed - get symbol
					a=getch();
					if (a!=*" ") break; //break loop
					a=getch(); //wait for nex key
				}
			} //while (1)
			break;
		} //case 1
		case 2: { //output
			cmd=mav18_dac_cmd;
			while (1) {
				printf(": ");
				scanf("%d",&ch1);
				if ((ch1==0)||(ch1>4)) break;
				data_b[0]=3;
				data_b[1]=ch1;	//channel
				printf("⮪(0-FFF): ");
				scanf("%x",&tok);
				data_b[2]=tok&0x0ff;
				data_b[3]=(tok>>8)&0x0ff;
				stat=mav18_cmd(base,cmd,data_b);
				printf("  st=%X\n",stat);
			}
			break;
		}
		case 3: { //command
			printf(" (1-, 2-., 3-.⮪): ");
			scanf("%d",&cmd);
			data_b[0]=0; //no (zero) parameters
			switch (cmd) { //parameters request
			case 1: {
				cmd=mav18_rst_cmd;
				break;
			}
			case 2: {
				cmd=mav18_cali_cmd;
				printf("७ ஢");
				break;
			}
			case 3: { //burnout current
				cmd=mav18_burn_cmd;
				data_b[0]=1;				//1 parameter
				printf("⮢ ⮪ (0-몫, 1-): ");
				scanf("%d",&data_b[1]);
				break;
			}
			default: cmd=0;
			} //switch cmd
			if (cmd==0) break;
			stat=mav18_cmd(base,cmd,data_b);
			printf("  st= %X",stat);

			break;
		} //case command
		case 4: { //service
			printf("ᯮ짮    ਢ  ࠡᯮᮡ \n");
			printf(" (1-.0, 2-.1, 3-䨪, 4-, 5- ): ");
			scanf("%d",&cmd);
			data_b[0]=0;
			switch (cmd) { //parameters request
			case 1: {
				cmd=mav18_cals0_cmd;
				printf("஢ . k: ");
				data_b[0]=1;
				scanf("%d",&data_b[1]);
				if ((data_b[1]<1)||(data_b[1]>16)) cmd=0;
				break;
			}
			case 2: {
				cmd=mav18_cals1_cmd;
				printf("஢ 誠. k: ");
				data_b[0]=1;
				scanf("%d",&data_b[1]);
				if ((data_b[1]<1)||(data_b[1]>16)) cmd=0;
				break;
			}
			case 3: { //read and modify
				printf("⥭/䨪 䥩᭮ . : ");
				scanf("%x",&adr);
				while (1) { //memory read/write loop
					stat=mav18_rd(base, adr, &a); //read byte
					if (stat!=0) { //bad status
						printf("stat=%04X\n",stat); break;
					}
					printf(" %02x-",a);
					stat=byte_in();		//input byte
					if (stat<0x0100) { //normal byte input
						stat=mav18_wr(base, adr, stat);		//write byte
						if (stat!=0) { //bad status
							printf("stat=%04X\n",stat); break;
						}
					} else		//no normal byte
					if ((stat>>8)!=*" ") break;
					adr++;
				} //while 1

				break;
			} //case read
			case 4: { //command
				printf(" ࠬ1 ࠬ2 ࠬ3: ");
				scanf("%x %x %x %x",&cmd,&data_b[1],&data_b[2],&data_b[3]);
				data_b[0]=3; //3 parameters
				break;
			}
			case 5: { //command
				cmd=(mav18_st_rd(base)&0x0C)>>2;//protection status
				printf("  (0-몫, 1-1/4, 2-1/2, 3-) %1X: ",cmd);
				scanf("%d",&cmd);
				cmd=(cmd&0x03)<<2;
				mav18_st_wr(base,cmd);			//set memory protection
			}
			default: cmd=0;
			} //switch cmd

			if ((cmd==0)||(cmd==3)) break;
			stat=mav18_cmd(base,cmd,data_b);
			printf("  st= %0X",stat);

			break;
		} //case service
		default: mode=0;
		} //switch

		if (mode==0) break; //break the loop

	} //while(1) main loop

}


