#!/usr/bin/env python3

import mobius
import sys

app = mobius.core.application ()
app.start ()

for url in sys.argv[1:]:
   print ()
   print (">>", url)
   print ("     Start         End     Sectors   Flags  Description")

   imagefile = mobius.vfs.new_imagefile_by_url (url)
   ps = mobius.vfs.partition_system (imagefile.new_reader (), imagefile.sector_size)

   if ps:
     for e in ps.get_entries ():
       print ('%10d  %10d  %10d  %6s  %s' % (e.starting_sector, e.ending_sector, e.sectors, e.flags, e.description))
   else:
     print ("No partition system found!")

app.stop ()
