#!/usr/bin/env python3

import mobius
import sys

def print_imagefile_info (imagefile):
  print ('Type: %s' % imagefile.type)
  print ('Size: %d bytes' % imagefile.size)
  print ('Sectors: %d' % imagefile.sectors)
  print ('Sector size: %d bytes' % imagefile.sector_size)

  for name, value in sorted (imagefile.get_attributes ().items ()):
    print ('%s: %s' % (name.replace ('_', ' ').capitalize (), value))

app = mobius.core.application ()
app.start ()

for uri in sys.argv[1:]:
   print ()
   print (">>", uri)

   imagefile = mobius.vfs.new_imagefile_by_url (uri)

   if imagefile.is_available ():
     print_imagefile_info (imagefile)

app.stop ()
