/**
 * Ce programme explique comment récupérer la taille des boîtes de textes avant 
 * de les afficher.
 *
 * Pour cela, le programme utilise les fonctions suivantes:
 *
 *------------------------------------------------------------------------------
 * MLV_text_size : Calcule la taille du texte qui sera affiché à l'écran
 *
 * void MLV_text_size(
 *     const char *    text,     Texte qui dit être affiché
 *     int *           width,    largeur du texte
 *     int *           height    hauteur du texte
 * );
 *
 *------------------------------------------------------------------------------
 * MLV_adapted_text_box_size : Calcul la taille de la boîte de texte qui serait
 *                             obtenue si vous utilisez la fonction :
 *                             MLV_adapted_box_size.
 *
 * int MLV_adapted_text_box_size(
 *     const char*    message,           texte qui sera affiché lorsque vous 
 *                                       utiliserez MLV_adapted_box.
 *     int            sizeInterligne,    Taille de l'interligne
 *     int *          result_width,      Largeur de la boîte que vous obtiendrez
 *                                       en utilisant MLV_adapted_box.
 *     int *          result_height      Hauteur de la boîte que vous obtiendrez
 *                                       en utilisant MLV_adapted_box.
 * );
 *
 *------------------------------------------------------------------------------
 */

#include <MLV/MLV_all.h>

//
// Fonction affichant les côtes d'une boîte de texte. Les paramètres sont 
// la position du sommet Nord-Ouest ( paramètres x et y ) et la taille de la 
// boîte de texte ( paramètres width et heuigt ).
//
void print_cote( int x, int y, int width, int height ){
	int espace = 3;
	int sizeLine = 10;
	int N = y;
	int O = x;
	int S = y + height -1;
	int E = x + width - 1;

	MLV_draw_line(O, N - espace, O, N - espace - sizeLine , MLV_COLOR_GREEN);
	MLV_draw_line(E, N - espace, E, N - espace - sizeLine , MLV_COLOR_GREEN);
	MLV_draw_line(O, S + espace, O, S + espace + sizeLine , MLV_COLOR_GREEN);
	MLV_draw_line(E, S + espace, E, S + espace + sizeLine , MLV_COLOR_GREEN);

	MLV_draw_line(O - espace, N, O - espace - sizeLine, N, MLV_COLOR_GREEN);
	MLV_draw_line(O - espace, S, O - espace - sizeLine, S, MLV_COLOR_GREEN);
	MLV_draw_line(E + espace, N, E + espace + sizeLine, N, MLV_COLOR_GREEN);
	MLV_draw_line(E + espace, S, E + espace + sizeLine, S, MLV_COLOR_GREEN);
}

//
// Programme principal
//
// Attention ! 
// Pour pouvoir compiler ce programme sous windows et sous macintosh,
// il faut, pour la déclaration du main, respecter strictement la syntaxe
// suivante :
//
int main( int argc, char *argv[] ){
	int width = 640, height = 480;
	//
	// Créé et affiche la fenêtre
	//
	MLV_create_window( "Nom_fenetre", "nom_icone", width, height );

	// texte à afficher dans une boîte
	char* text = "Voici une boite de texte, centré par rapport à la fenetre.";
	// Taille de la futur boite qui affichera le texte de la variable text.
	int width_text, height_text; 
	//
	// Récupère la taile de la boite de texte qui affichera le texte
	// contenu dans la variable text.
	//
	MLV_text_size( text, &width_text, &height_text );
	int positionX = (width-width_text)/2, positionY = 100;

	//
	// Affichage du texte
	//
	MLV_draw_text( positionX, positionY, text, MLV_COLOR_GREEN );
	//
	// Affichage des côte du texte fraîchement affiché.
	//
	print_cote( positionX, positionY, width_text, height_text );

	//
	// Second texte à afficher
	//
	char *text_box = "Voici une boîte de texte.\nCette Boîte de texte est elle aussi centré horizontalement dans la fenetre.";

	int width_box = 0 , height_box = 0, size_interligne = 9;

	//
	// Récupère la taille de la boite de texte qui affichera le texte
	// contenu dans la variable text_box.
	//
	MLV_adapted_text_box_size(
		text_box,
		size_interligne,
		&width_box, &height_box
	);
	//
	// Calcul la position idéale pour la boîte de texte
	//
	int positionBoxX = (width-width_box)/2, positionBoxY = 300;

	//
	// Affiche la boîte de texte.
	//
	MLV_draw_adapted_text_box(
		positionBoxX, positionBoxY,
		text_box,
		size_interligne,
		MLV_COLOR_RED, MLV_COLOR_GREEN, MLV_COLOR_BLACK,
		MLV_TEXT_CENTER,
		NULL, NULL
	);
	//
	// Affiche les côtes de la boîte de texte.
	//
	print_cote( positionBoxX, positionBoxY, width_box, height_box );

	//
	//  Met à jour l'affichage de la fenêtre
	//
	MLV_actualise_window();

	//
	// Attend 15 secondes
	//
	MLV_wait_seconds( 15 );

	//
	// Ferme la fenêtre
	//
	MLV_close_window();
	return 0;
}
