/* ipc.h - Generalized interprocess communication 
 *
 * Copyright (C) 2004, 2005 Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef IPC_H
#define IPC_H

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>

typedef enum _IPCArgType IPCArgType;
typedef enum _IPCError IPCError;
typedef struct _IPC IPC;

enum _IPCArgType {
    IPC_END,
    IPC_INT64,
    IPC_INT32,
    IPC_INT,
    IPC_BOOL,
    IPC_STR,
};

enum _IPCError {
    IPC_ERROR_WRITE,
    IPC_ERROR_READ,
    IPC_ERROR_DATA,
};

typedef bool (*IPCMessageFunction)(IPC *ipc, uint32_t id, void *userdata);
typedef void (*IPCErrorFunction)(IPC *ipc, IPCError error, int result, void *userdata);

IPC *ipc_new(int fd, IPCMessageFunction handle_message, IPCErrorFunction handle_error, void *userdata);
void ipc_free(IPC *ipc);
bool ipc_put(IPC *ipc, uint32_t id, ...);
bool ipc_get_id(IPC *ipc, uint32_t *id);
bool ipc_get(IPC *ipc, uint32_t id, ...);
bool ipc_handle(IPC *ipc);

#endif
