/*
 * @(#)Constraint.java          1.0            6 September 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.type;

/**
 * The common superclass for all type constraints.
 *
 * @version  1.0
 * @author   Per Cederberg, per@percederberg.net
 */
public abstract class Constraint extends Object {

    /**
     * Checks if this constraint equals another constraint.
     *
     * @param obj    the object to compare with
     *
     * @return  true if equal, otherwise false
     */
    public abstract boolean equals(Object obj);

    /**
     * Checks if two values are equal, considering two null values to
     * be equal.
     *
     * @param  a       the first object
     * @param  b       the second object
     * @return true if the objects are equal, false otherwise
     */
    protected static boolean equalsValue(Object a, Object b) {
        if (a == null) {
            return a == b;
        } else {
            return a.equals(b);
        }
    }

    /**
     * Returns a string description of this constraint.
     *
     * @return a string description
     */
    public abstract String toString();

    /**
     * Transfers the constraint information from this object to a type
     * converter object. The calling conventions declared in the
     * TypeConverter class are followed.
     *
     * @param   converter     a type converter
     */
    public abstract void transferConstraint(TypeConverter converter);

}
