/*
 * @(#)SnmpModuleIdentityType.java
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2003 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.type;

import java.util.Date;

/**
 * A class for handling type information for the SNMP module identity
 * macro type.
 *
 * @version  1.1
 * @author   Per Cederberg, per@percederberg.net
 */
public class SnmpModuleIdentityType extends Type {
    // TODO: include revision information
    // TODO: add methods for reading the instance variables

    /**
     * The last update date.
     */
    private Date lastUpdate = null;

    /**
     * The organization information.
     */
    private String organization = "";

    /**
     * The contact information.
     */
    private String contactInfo = "";

    /**
     * The description text.
     */
    private String description = "";

    /**
     * Creates a new SNMP module identity type with the specified 
     * values.
     *
     * @param update    the last update date
     * @param org       the organization information
     * @param contact   the contact information
     * @param desc      the module description
     */
    public SnmpModuleIdentityType(Date update, 
                                  String org, 
                                  String contact, 
                                  String desc) {

        this.lastUpdate = update;
        this.organization = org;
        this.contactInfo = contact;
        this.description = desc;
    }

    /**
     * Checks if this type equals another.
     *
     * @param  obj       an object
     * @return true if the types are equal, false otherwise
     */
    public boolean equals(Object obj) {
        return this == obj;
    }

    /**
     * Returns a description of this type.
     *
     * @return a description of the type
     */
    public String toString() {
        return "ModuleIdentity";
    }

    /**
     * Transfers the type information from this type to a type
     * converter object. The calling conventions declared in the
     * TypeConverter class are followed.
     *
     * @param   converter     a type converter
     */
    public void transferType(TypeConverter converter) {
        throw new UnsupportedOperationException(
            "This type cannot be mapped to anything.");
    }
}
