/*
 * @(#)Token.java               1.3              31 August 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.asn1.node;

/**
 * A class representing tokens.
 *
 * @version   1.3
 * @author    Per Cederberg, per@percederberg.net
 */
public class Token extends Node {

    /**
     * beginLine and beginColumn describe the position of the first
     * character of this token; endLine and endColumn describe the
     * position of the last character of this token.
     */
    public int beginLine, beginColumn, endLine, endColumn;

    /**
     * The string image of the token.
     */
    public String image;

    /**
     * A reference to the next regular (non-special) token from the
     * input stream. If this is the last token from the input stream,
     * or if the token manager has not read tokens beyond this one,
     * this field is set to null. This is true only if this token is
     * also a regular token. Otherwise, see below for a description of
     * the contents of this field.
     */
    public Token next;

    /**
     * This field is used to access special tokens that occur prior to
     * this token, but after the immediately preceding regular
     * (non-special) token. If there are no such special tokens, this
     * field is set to null. When there are more than one such special
     * token, this field refers to the last of these special tokens,
     * which in turn refers to the next previous special token through
     * its specialToken field, and so on until the first special token
     * (whose specialToken field is null). The next fields of special
     * tokens refer to other special tokens that immediately follow it
     * (without an intervening regular token). If there is no such
     * token, this field is null.
     */
    public Token specialToken;

    /**
     * Returns the image.
     *
     * @return the token image
     */
    public final String toString() {
        return image;
    }

    /**
     * Returns a new Token object, by default. However, if you want,
     * you can create and return subclass objects based on the value
     * of ofKind. Simply add the cases to the switch for all those
     * special cases. For example, if you have a subclass of Token
     * called IDToken that you want to create if ofKind is ID, simlpy
     * add something like:
     *
     *    case MyParserConstants.ID: return new IDToken();
     *
     * to the following switch statement. Then you can cast
     * matchedToken variable to the appropriate type and use it in
     * your lexical actions.
     *
     * @param ofKind     the token kind
     *
     * @return a new token object
     */
    public static final Token newToken(int ofKind) {
        return new Token();
    }

    /**
     * Returns the first line for the token.
     *
     * @return the first line
     */
    public int firstLine() {
        return beginLine;
    }

    /**
     * Returns the first column for the token.
     *
     * @return the first column
     */
    public int firstColumn() {
        return beginColumn;
    }

    /**
     * Returns the last line for the token.
     *
     * @return the last line
     */
    public int lastLine() {
        return endLine;
    }

    /**
     * Returns the last column for the token.
     *
     * @return the last column
     */
    public int lastColumn() {
        return endColumn;
    }

}
