/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib.example;

import java.io.File;
import java.util.Vector;
import net.percederberg.mib.Mib;

public class MibValidator {
    static /* synthetic */ Class class$net$percederberg$mib$example$MibValidator;

    public static void main(String[] args) {
        Vector files = new Vector();
        int errors = 0;
        if (args.length < 1) {
            MibValidator.printHelp("No dir(s) or file(s) specified");
            System.exit(1);
        }
        int i = 0;
        while (i < args.length) {
            try {
                MibValidator.addFile(new File(args[i]), files);
            }
            catch (Exception e) {
                MibValidator.printHelp(e.getMessage());
                System.exit(1);
            }
            ++i;
        }
        i = 0;
        while (i < files.size()) {
            try {
                System.out.print("Reading " + files.get(i) + "... ");
                Mib mib = new Mib((File)files.get(i));
                if (mib.getErrorCount() + mib.getWarningCount() == 0) {
                    System.out.println("[OK]");
                } else {
                    ++errors;
                    System.out.println("[FAILED]");
                }
                System.out.print(mib.getAllMessages());
            }
            catch (Exception e) {
                System.out.println("[FAILED]");
                ++errors;
                e.printStackTrace(System.out);
            }
            ++i;
        }
        System.exit(errors);
    }

    private static void printHelp(String error) {
        System.err.println("Syntax: java " + (class$net$percederberg$mib$example$MibValidator == null ? (class$net$percederberg$mib$example$MibValidator = MibValidator.class$("net.percederberg.mib.example.MibValidator")) : class$net$percederberg$mib$example$MibValidator) + "<dir(s) or file(s)>");
        System.err.println();
        if (error != null) {
            System.err.print("Error: ");
            System.err.println(error);
            System.err.println();
        }
    }

    private static void addFile(File file, Vector res) {
        if (!file.exists()) {
            MibValidator.printHelp("File not found: " + file);
            System.exit(1);
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory() || files[i].getName().endsWith(".mib")) {
                    MibValidator.addFile(files[i], res);
                }
                ++i;
            }
        } else {
            res.add(file);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

