/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib.asn1.node;

import java.util.Enumeration;
import java.util.Vector;
import net.percederberg.mib.asn1.node.Node;

public class Production
extends Node {
    private Vector children = new Vector();

    public Production(int kind) {
        this.kind = kind;
    }

    public Production(int kind, Node parent) {
        this.kind = kind;
        this.setParent(parent);
    }

    public void addChild(Node child) {
        this.children.add(child);
    }

    public Node childAfter(Node child) {
        int i = this.children.indexOf(child);
        if (i + 1 < this.children.size()) {
            return (Node)this.children.elementAt(i + 1);
        }
        return null;
    }

    public Node childAt(int index) {
        return (Node)this.children.elementAt(index);
    }

    public Node childOfType(int type) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Node temp = (Node)enumeration.nextElement();
            if (!temp.isType(type)) continue;
            return temp;
        }
        return null;
    }

    public int children() {
        return this.children.size();
    }

    public int childrenOfType(int type) {
        Enumeration enumeration = this.children.elements();
        int counter = 0;
        while (enumeration.hasMoreElements()) {
            Node temp = (Node)enumeration.nextElement();
            if (!temp.isType(type)) continue;
            ++counter;
        }
        return counter;
    }

    public int firstLine() {
        if (this.children() > 0) {
            return this.childAt(0).firstLine();
        }
        return -1;
    }

    public int firstColumn() {
        if (this.children() > 0) {
            return this.childAt(0).firstColumn();
        }
        return -1;
    }

    public int lastLine() {
        if (this.children() > 0) {
            return this.childAt(this.children() - 1).lastLine();
        }
        return -1;
    }

    public int lastColumn() {
        if (this.children() > 0) {
            return this.childAt(this.children() - 1).lastColumn();
        }
        return -1;
    }
}

