/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib.type;

import net.percederberg.mib.type.Constraint;
import net.percederberg.mib.type.TypeConverter;

public class ValueRangeConstraint
extends Constraint {
    public static final Number MIN = null;
    public static final Number MAX = null;
    private Number lower;
    private Number upper;

    public ValueRangeConstraint(Number lower, Number upper) {
        this(lower, true, upper, true);
    }

    public ValueRangeConstraint(Number lower, boolean lowinc, Number upper, boolean upinc) {
        this.lower = lowinc ? (Number)lower : (Number)(lower == null ? (Number)MIN : (Number)new Long(lower.longValue() + 1L));
        this.upper = upinc ? (Number)upper : (Number)(upper == null ? (Number)MIN : (Number)new Long(upper.longValue() + 1L));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueRangeConstraint) {
            ValueRangeConstraint c = (ValueRangeConstraint)obj;
            return Constraint.equalsValue(this.lower, c.lower) && Constraint.equalsValue(this.upper, c.upper);
        }
        return false;
    }

    public String toString() {
        String res = "";
        res = this.lower == MIN ? res + "MIN" : res + this.lower.longValue();
        res = res + "..";
        res = this.upper == MAX ? res + "MAX" : res + this.upper.longValue();
        return res;
    }

    public void transferConstraint(TypeConverter converter) {
        converter.transferValueLimits(this.minValue(), this.maxValue());
    }

    protected int minValue() {
        if (this.lower == MIN || this.lower.longValue() < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (this.lower.longValue() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.lower.intValue();
    }

    protected int maxValue() {
        if (this.upper == MAX || this.upper.longValue() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (this.upper.longValue() < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return this.upper.intValue();
    }
}

